@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');
  $show_date = get_field('show_date');

  $args = array(
      'post_type' => 'post',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'category':
            $category = get_field('category');
            $args['tax_query'][] = 
                [
                    'cat' => $category,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break;

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} posts-list -mx-4">

    <div class="flex flex-wrap">
        @php
            global $post;
        @endphp
        @foreach($posts as $key => $post)
            <div class="w-full lg:w-1/3 sm:w-1/2">
                @include('partials.teaser-' . get_post_type($post), ['show-date' => $show_date])
            </div>
        @endforeach
    </div>
</div>
