@extends('layouts.app')

@section('content')
  <div class="container">
    @include('partials.page-header', ['is_blog' => true])
    @include('partials.filter-buttons', ['is_category' => true, 'post_type' => 'post'])

    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'thor') }}
      </div>
      {!! get_search_form(false) !!}
    @else
      <div class="flex flex-wrap -mx-4 gap-y-15">
        @while (have_posts()) @php the_post() @endphp
          @php 
            $is_highlighted = get_field('is_highlighted');
          @endphp
          @if($is_highlighted)
            <div class="w-full is-highlighted">
          @else
            <div class="w-full lg:w-1/3 sm:w-1/2">
          @endif
              @include('partials.teaser-'.get_post_type(), ['show_date' => true, 'show_category' => true])
            </div>
        @endwhile
      </div><!--row-->
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
