<article {{post_class('teaser-post')}}>
    @if($show_category)
      @php
        $categories = get_the_category();
        $video = get_field('video');
      @endphp
      @foreach($categories as $key => $category)
        <a
          href="{!! get_category_link($category) !!}"
          class="category">
            {!! $category->name !!}
        </a>
      @endforeach
    @endif
  <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
    <figure>
        <img
          class="lazy"
          src="{!! get_the_post_thumbnail_url(get_the_ID(), 'mini') !!}"
          data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
        />
        @if($video)
          <video preload="none" loop muted playsinline>
            <source src="{!! $video['url'] !!}" type="video/mp4" />
          </video>
        @endif
      </figure>
  </a>

  <header>
    @if($show_date)
      <div class="time"
          datetime="{{ get_post_time('c', true) }}">
        {{ get_the_date('d.m.Y') }}
      </div>
    @endif
    <a href="{{ get_permalink() }}" title="{!! get_the_title() !!}">
      <h2>
        {!! get_the_title() !!}
      </h2>
    </a>
  </header>
</article>
