import Swiper, { Autoplay } from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, Autoplay]);

export default (() => {
    window.addEventListener('load', function () {
      const sheetList = new Swiper('.sheet-list .sheet.finiture, .sheet-list .sheet.tints', {
        freeMode: true,
        freeModeSticky: true,
        slidesPerView: 2.2,
        spaceBetween: 16,
        scrollbar: {
          draggable: false,
        },
        navigation: {
          nextEl: '.sheet-list .sheet .swiper-button-next',
          prevEl: '.sheet-list .sheet .swiper-button-prev',
        },
        breakpoints: {
          768: {
            slidesPerView: 3,
            spaceBetween: 32,
          },
          1024: {
            slidesPerView: 4,
          },
        },
      });

      const decorsList = new Swiper('.sheet-list .sheet.properties', {
        freeMode: true,
        freeModeSticky: true,
        slidesPerView: 3,
        autoplay: {
          delay: 3000,
        },
        spaceBetween: 16,
        scrollbar: {
          draggable: true,
        },
        breakpoints: {
          768: {
            slidesPerView: 4,
            spaceBetween: 32,
          },
          1024: {
            slidesPerView: 6,
          },
          1280: {
            slidesPerView: 7,
          },
        },
      });
    })
})()