import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar]);
export default (() => {
  window.addEventListener('load', function () {
    const timeline = new Swiper('.timeline .milestone', {
      freeMode: true,
      freeModeSticky: true,
      slidesPerView: 1,
      spaceBetween: 0,
      initialSlide: this.document.querySelectorAll('.swiper-slide').length -1,
      scrollbar: {
        draggable: false,
      },
      navigation: {
        nextEl: '.timeline .milestone .swiper-button-next',
        prevEl: '.timeline .milestone .swiper-button-prev',
      },
      pagination: {
        el: '.timeline .milestone .swiper-pagination',
      },
    });

    const pagination = document.querySelectorAll('.timeline .pagination')

    pagination.forEach(element => {
      element.addEventListener('click', () => {

        const index = element.dataset.index
        timeline.slideTo(index)
      })
    })

    renderActiveBullet(pagination, timeline)
    timeline.on('slideChange', () => {
      renderActiveBullet(pagination, timeline)
    })
  })
})()




function renderActiveBullet(pagination, swiper) {
  pagination.forEach(element => {
    if (element.dataset.index == swiper.activeIndex) {
      element.classList.add('active')
    } else {
      element.classList.remove('active')
    }
  })
}