import {gsap, Power1} from 'gsap'

export default (() => {
    const teaserPosts = document.querySelectorAll('.teaser-post')

    teaserPosts.forEach((teaser) => {
        const video = teaser.querySelector('video')
        let t1 = gsap.timeline()

        t1.to(video, {
            opacity: 1,
            duration: 0.2,
            ease: Power1.easeOut,
            onComplete: () => {
                if (video) {
                    video.play()
                }
            },
            onReverseComplete: () => {
                if (video) {
                    video.pause()
                }
            },
        })

        t1.pause()

        teaser.addEventListener('mouseenter', () => {
            t1.play()
        })

        teaser.addEventListener('mouseleave', () => {
            t1.reverse()
        })
    })
})()