/*

Tailwind - The Utility-First CSS Framework

A project by Adam Wathan (@adamwathan), Jonathan Reinink (@reinink),
David Hemphill (@davidhemphill) and Steve Schoger (@steveschoger).

Welcome to the Tailwind config file. This is where you can customize
Tailwind specifically for your project. Don't be intimidated by the
length of this file. It's really just a big JavaScript object and
we've done our very best to explain each section.

View the full documentation at https://tailwindcss.com.


|-------------------------------------------------------------------------------
| The default config
|-------------------------------------------------------------------------------
|
| This variable contains the default Tailwind config. You don't have
| to use it, but it can sometimes be helpful to have available. For
| example, you may choose to merge your custom configuration
| values with some of the Tailwind defaults.
|
*/

// let defaultConfig = require('tailwindcss/defaultConfig')


/*
|-------------------------------------------------------------------------------
| Colors                                    https://tailwindcss.com/docs/colors
|-------------------------------------------------------------------------------
|
| Here you can specify the colors used in your project. To get you started,
| we've provided a generours palette of great looking colors that are perfect
| for prototyping, but don't hesitate to change them for your project. You
| own these colors, nothing will break if you change everything about them.
|
| We've used literal color names ("red", "blue", etc.) for the default
| palette, but if you'd rather use functional names like "primary" and
| "secondary", or even a numeric scale like "100" and "200", go for it.
|
*/

//
// To choose color shades use: https://superdevresources.com/tools/color-shades
//

let colors = {
  transparent: 'transparent',

  black: '#000',
  white: '#fff',

  primary: {
      25:  "#f5f6f6",
      50:  "#f3f4f4",
      100: "#d9d9d9",
      200: "#b3b3b3",
      250: "#adadac",
      300: "#8e8e8e",
      400: "#686868",
      500: "#424242",
      600: "#353535",
      700: "#282828",
      800: "#1a1a1a",
      900: "#0d0d0d"
  },
}

module.exports = {
  mode: 'jit',
  purge: {
    enabled: true,
    content: [
      './resources/**/*.scss',
      './resources/**/*.php',
    ],
  },
  // prefix: '',
  // important: false,
  separator: ':',
  theme: {
     screens: {
       sm: '640px',
       'sm-1': '639px',
       md: '768px',
       'md-1': '767px',
       lg: '1024px',
       'lg-1': '1023px',
       xl: '1280px',
       'xl-1': '1279px',
       '2xl': '1440px',
       '2xl-1': '1439px',
       '3xl': '1830px',
       '3xl-1': '1829px',
     },
    colors: colors,
    spacing: {
      px: '1px',
      '0': '0',
      '1': '0.25rem',
      '1.5': '0.375rem',
      '2': '0.5rem',
      '2.5': '0.675rem',
      '3': '0.75rem',
      '3.5': '0.875rem',
      '4': '1rem',
      '4.5': '1.125rem',
      '5': '1.25rem',
      '5.5': '1.375rem',
      '6': '1.5rem',
      '6.5': '1.625rem',
      '7': '1.75rem',
      '7.5': '1.875rem',
      '8': '2rem',
      '8.5': '2.125rem',
      '9': '2.25rem',
      '9.5': '2.375rem',
      '10': '2.5rem',
      '11': '2.75rem',
      '12': '3rem',
      '13': '3.25rem',
      '14': '3.5rem',
      '15': '3.75rem',
      '16': '4rem',
      '17': '4.25rem',
      '18': '4.5rem',
      '19': '4.75rem',
      '20': '5rem',
      '22': '5.5rem',
      '24': '6rem',
      '26': '6.5rem',
      '28': '7rem',
      '30': '7.5rem',
      '32': '8rem',
      '36': '9rem',
      '40': '10rem',
      '44': '11rem',
      '48': '12rem',
      '52': '13rem',
      '56': '14rem',
      '60': '15rem',
      '64': '16rem',
      '72': '18rem',
      '80': '20rem',
      '92': '24rem',
      '100': '28rem',
    },
    // backgroundColor: theme => theme('colors'),
    // backgroundPosition: {
    //   bottom: 'bottom',
    //   center: 'center',
    //   left: 'left',
    //   'left-bottom': 'left bottom',
    //   'left-top': 'left top',
    //   right: 'right',
    //   'right-bottom': 'right bottom',
    //   'right-top': 'right top',
    //   top: 'top',
    // },
    // backgroundSize: {
    //   auto: 'auto',
    //   cover: 'cover',
    //   contain: 'contain',
    // },
    // borderColor: theme => ({
    //   ...theme('colors'),
    //   default: theme('colors.gray.300', 'currentColor'),
    // }),
    borderRadius: {
      none: '0',
      sm: '0.125rem',
      default: '0.25rem',
      md: '0.313rem',
      lg: '0.5rem',
      full: '9999px',
    },
    // borderWidth: {
    //   default: '1px',
    //   '0': '0',
    //   '2': '2px',
    //   '4': '4px',
    //   '8': '8px',
    // },
    boxShadow: {
      default: '0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)',
      md: '0 0px 4px 0px rgba(0, 0, 0, 0.2), 0 0px 0px 0px rgba(0, 0, 0, 0)',
      lg: '0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05)',
      xl: '0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04)',
      '2xl': '0 25px 50px -12px rgba(0, 0, 0, 0.25)',
      inner: 'inset 0 2px 4px 0 rgba(0, 0, 0, 0.06)',
      outline: '0 0 0 3px rgba(66, 153, 225, 0.5)',
      none: 'none',
    },
    container: {
      center: true,
      padding: '2.5rem',
    },
    // cursor: {
    //   auto: 'auto',
    //   default: 'default',
    //   pointer: 'pointer',
    //   wait: 'wait',
    //   text: 'text',
    //   move: 'move',
    //   'not-allowed': 'not-allowed',
    // },
    // fill: {
    //   current: 'currentColor',
    // },
    // flex: {
    //   '1': '1 1 0%',
    //   auto: '1 1 auto',
    //   initial: '0 1 auto',
    //   none: 'none',
    // },
    // flexGrow: {
    //   '0': '0',
    //   default: '1',
    // },
    // flexShrink: {
    //   '0': '0',
    //   default: '1',
    // },
    fontFamily: {
      sans: [
        'Plain',
        'sans-serif',
      ],
      serif: [
        'Georgia',
        'Cambria',
        '"Times New Roman"',
        'Times',
        'serif',
      ],
      mono: [
        'Jesolo Mono',
        'Monaco',
        'Consolas',
        '"Liberation Mono"',
        '"Courier New"',
        'monospace',
      ],
    },
    fontSize: {
      xxxs: '0.625rem',
      xxs: '0.688rem',
      xs: '0.75rem',
      sm: '0.875rem',
      base: '1rem',
      lg: '1.125rem',
      xl: '1.625rem',
      '2xl': '2.5rem',
      '3xl': '3.75rem',
      '4xl': '12.5rem',
    },
    // fontWeight: {
    //   hairline: '100',
    //   thin: '200',
    //   light: '300',
    //   normal: '400',
    //   medium: '500',
    //   semibold: '600',
    //   bold: '700',
    //   extrabold: '800',
    //   black: '900',
    // },
    // height: theme => ({
    //   auto: 'auto',
    //   ...theme('spacing'),
    //   full: '100%',
    //   screen: '100vh',
    // }),
    inset: theme => ({
      '0': '0',
      auto: 'auto',
      ...theme('spacing'),
    }),
    // letterSpacing: {
    //   tighter: '-0.05em',
    //   tight: '-0.025em',
    //   normal: '0',
    //   wide: '0.025em',
    //   wider: '0.05em',
    //   widest: '0.1em',
    // },
    // lineHeight: {
    //   none: '1',
    //   tight: '1.25',
    //   snug: '1.375',
    //   normal: '1.5',
    //   relaxed: '1.625',
    //   loose: '2',
    // },
    // listStyleType: {
    //   none: 'none',
    //   disc: 'disc',
    //   decimal: 'decimal',
    // },
    // margin: (theme, { negative }) => ({
    //   auto: 'auto',
    //   ...theme('spacing'),
    //   ...negative(theme('spacing')),
    // }),
    // maxHeight: {
    //   full: '100%',
    //   screen: '100vh',
    // },
    // maxWidth: {
    //   xs: '20rem',
    //   sm: '24rem',
    //   md: '28rem',
    //   lg: '32rem',
    //   xl: '36rem',
    //   '2xl': '42rem',
    //   '3xl': '48rem',
    //   '4xl': '56rem',
    //   '5xl': '64rem',
    //   '6xl': '72rem',
    //   full: '100%',
    // },
    minHeight: theme => ({
      '0': '0',
      full: '100%',
      screen: '100vh',
      ...theme('spacing'),
    }),
    minWidth: theme => ({
      '0': '0',
      full: '100%',
      screen: '100vh',
      ...theme('spacing'),
    }),
    // objectPosition: {
    //   bottom: 'bottom',
    //   center: 'center',
    //   left: 'left',
    //   'left-bottom': 'left bottom',
    //   'left-top': 'left top',
    //   right: 'right',
    //   'right-bottom': 'right bottom',
    //   'right-top': 'right top',
    //   top: 'top',
    // },
    // opacity: {
    //   '0': '0',
    //   '25': '0.25',
    //   '50': '0.5',
    //   '75': '0.75',
    //   '100': '1',
    // },
    // order: {
    //   first: '-9999',
    //   last: '9999',
    //   none: '0',
    //   '1': '1',
    //   '2': '2',
    //   '3': '3',
    //   '4': '4',
    //   '5': '5',
    //   '6': '6',
    //   '7': '7',
    //   '8': '8',
    //   '9': '9',
    //   '10': '10',
    //   '11': '11',
    //   '12': '12',
    // },
    // padding: theme => theme('spacing'),
    // stroke: {
    //   current: 'currentColor',
    // },
    // textColor: theme => theme('colors'),
    // width: theme => ({
    //   auto: 'auto',
    //   ...theme('spacing'),
    //   '1/2': '50%',
    //   '1/3': '33.333333%',
    //   '2/3': '66.666667%',
    //   '1/4': '25%',
    //   '2/4': '50%',
    //   '3/4': '75%',
    //   '1/5': '20%',
    //   '2/5': '40%',
    //   '3/5': '60%',
    //   '4/5': '80%',
    //   '1/6': '16.666667%',
    //   '2/6': '33.333333%',
    //   '3/6': '50%',
    //   '4/6': '66.666667%',
    //   '5/6': '83.333333%',
    //   '1/12': '8.333333%',
    //   '2/12': '16.666667%',
    //   '3/12': '25%',
    //   '4/12': '33.333333%',
    //   '5/12': '41.666667%',
    //   '6/12': '50%',
    //   '7/12': '58.333333%',
    //   '8/12': '66.666667%',
    //   '9/12': '75%',
    //   '10/12': '83.333333%',
    //   '11/12': '91.666667%',
    //   full: '100%',
    //   screen: '100vw',
    // }),
    // zIndex: {
    //   auto: 'auto',
    //   '0': '0',
    //   '10': '10',
    //   '20': '20',
    //   '30': '30',
    //   '40': '40',
    //   '50': '50',
    // },
  },
  variants: {
    alignContent: ['responsive','hover','first','last','even'],
    alignItems: ['responsive','hover','first','last','even'],
    alignSelf: ['responsive','hover','first','last','even'],
    backgroundAttachment: ['responsive'],
    backgroundColor: ['responsive','hover'],
    backgroundPosition: ['responsive','hover'],
    backgroundRepeat: ['responsive'],
    backgroundSize: ['responsive','hover'],
    transition: ['responsive','hover'],
    borderColor: ['responsive','hover','first','last'],
    borderRadius: ['responsive','hover','first','last'],
    borderStyle: ['responsive','first','last'],
    borderWidth: ['responsive','first','last'],
    boxShadow: ['responsive','hover'],
    cursor: ['responsive','hover'],
    display: ['responsive','first','last','even'],
    flex: ['responsive'],
    flexDirection: ['responsive'],
    flexGrow: ['responsive'],
    flexShrink: ['responsive'],
    flexWrap: ['responsive'],
    float: ['responsive'],
    fontFamily: ['responsive'],
    fontSize: ['responsive','hover'],
    fontSmoothing: ['responsive'],
    fontStyle: ['responsive'],
    fontWeight: ['responsive','hover'],
    gridColumn: ['responsive','first','last','even'],
    gridColumnStart: ['responsive','first','last','even'],
    gridColumnEnd: ['responsive','first','last','even'],
    gridRow: ['responsive','first','last','even'],
    gridRowStart: ['responsive','first','last','even'],
    gridRowEnd: ['responsive','first','last','even'],
    height: ['responsive'],
    inset: ['responsive'],
    justifyContent: ['responsive','first','last','even'],
    letterSpacing: ['responsive'],
    lineHeight: ['responsive'],
    listStylePosition: ['responsive'],
    listStyleType: ['responsive'],
    margin: ['responsive','hover','first','last','even'],
    maxHeight: ['responsive'],
    maxWidth: ['responsive'],
    minHeight: ['responsive'],
    minWidth: ['responsive'],
    objectFit: ['responsive'],
    objectPosition: ['responsive'],
    opacity: ['responsive','hover'],
    order: ['responsive'],
    outline: ['responsive', 'focus'],
    overflow: ['responsive'],
    padding: ['responsive','hover','first','last','even'],
    pointerEvents: ['responsive'],
    position: ['responsive'],
    stroke: ['responsive'],
    tableLayout: ['responsive'],
    textAlign: ['responsive'],
    textColor: ['responsive', 'hover'],
    textDecoration: ['responsive', 'hover'],
    textTransform: ['responsive'],
    visibility: ['responsive'],
    whitespace: ['responsive'],
    width: ['responsive','first','last','even'],
    wordBreak: ['responsive'],
    zIndex: ['responsive'],
  },
  corePlugins: {},
  plugins: [],
}