@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');

  $args = array(
      'post_type' => 'decors',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'taxonomy':
            $taxonomy = get_field('taxonomy');
            $args['tax_query'][] = 
                [
                    'taxonomy' => 'decors_category',
                    'terms' => $taxonomy,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break;

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} decors-list">

    <div class="swiper-container decors">
        <div class="arrow-container">
            <div class="swiper-button-prev">
              @svg('images/arrow-left.svg')
            </div>
            <div class="swiper-button-next">
              @svg('images/arrow-right.svg')
            </div>
        </div>
        <div class="swiper-wrapper">
            @foreach($posts as $key => $post)
                <div class="swiper-slide">
                    <div class="single">
                        @include('partials.teaser-' . get_post_type($post))
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
