@php
    $block_info = App::get_block_info($block);
    $pie_value = get_field('pie_value');

    $values = [];
    $colors = [];
    $descriptions = [];

    foreach ($pie_value as $key => $single) {
        $values [] = $single['value'];
        $colors [] = $single['color'];
        $descriptions [] = $single['description'];
    }
@endphp
<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} pie-chart">
    <div class="chart"><canvas class="pie"></canvas></div>
    <div class="legend">
      @foreach ($pie_value as $single)
          <div class="wrapper">
            <div style="background-color: {!! $single['color'] !!}"
                 class="circle"></div>
            <div class="title">
              <span>{!! $single['value'] . '%' !!}</span>
              <span>{!! $single['description'] !!}</span>
            </div>
          </div>
      @endforeach
    </div>
</div>

<script async
    src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"
    type="text/javascript">
</script>
<script async>

      var waitForChart = setInterval(function () {
        if (typeof Chart != 'undefined') {

            const ctx = document.querySelector('.pie-chart .pie').getContext('2d');
            const colors = {!! json_encode($colors) !!}
            let rgba = []

            function hexToRGB(hex) {
                var r = parseInt(hex.slice(1, 3), 16),
                    g = parseInt(hex.slice(3, 5), 16),
                    b = parseInt(hex.slice(5, 7), 16);

                return "rgba(" + r + ", " + g + ", " + b + ", " + 1 + ")";
            }

            colors.forEach(element => {
              let newColor = hexToRGB(element, 1)
              rgba.push(newColor)
            });

            const myChart = new Chart(ctx, {
              type: 'doughnut',
              data: {
                labels: {!! json_encode($descriptions) !!},
                datasets: [{
                  data: {!! json_encode($values) !!},
                  backgroundColor: rgba,
                  spacing: 0.1,
                  cutout: '73%',
                }],
              },
              options: {
                events: [],
                animation: {
                  duration: 3000,
                },
                responsive: false,
                plugins: {
                  legend: {
                      display: false,
                      position: 'right',
                      labels: {
                          fontColor: "white",
                          boxWidth: 20,
                          usePointStyle: true,
                          boxHeight: 20,
                          padding: 20
                      }
                  }
                }
              }
            });

            

            clearInterval(waitForChart);
        }
    }, 100);
</script>