@php
    $args = [
        'hide_empty' => true
];

    if($is_category) {
        $terms = get_categories($args);
    } else {
        $terms = get_terms($post_type, $args);
    }

    $archive_link_active = true;
    foreach($terms as $term):
            if(get_queried_object()->term_id == $term->term_id):
                $archive_link_active = false;
            endif;
    endforeach;
@endphp

@if($terms)
    <div class="button-wrapper">
        <a class="button outlined @if($archive_link_active) current @endif" href="{!! get_post_type_archive_link($post_type) !!}">
            {!! __('Vedi tutti', 'thor') !!}
        </a>
        @foreach($terms as $key => $term)
            @php
                $link = get_category_link($term) ? get_category_link($term) : get_term_link($term, $post_type);
            @endphp
            <a href="{{ $link }}" class="button outlined @if(get_queried_object() == $term)current @endif">
                {!! $term->name !!}
            </a>
        @endforeach
    </div>
@endif