@php
    $additional_field_name = get_field('additional_field_name') ? : '';
    $additional_field_decor = get_field('additional_field_decor');

    $filters = [
        'Flooring' =>  [
            'f1',
            'f2'
        ],

        'Kitchen Top' =>  [
            'k1',
            'k2'
        ],

        'Table' =>  [
            't1',
            't2'
        ],

        $additional_field_name => [
            'additional_field_decor'
        ]

    ];
@endphp


<div class="focus">
    <h2>
        {!! __('Focus on', 'thor') !!}
    </h2>
    @foreach($filters as $key => $filter)
        <div class="container">
            @if($key)
                <h3>
                    {!! $key !!}
                </h3>
            @endif

            @php
                $posts = App::get_decors_filter_by_name($filter);
            @endphp

            <div class="inner">
                @foreach($posts as $key => $post)
                    @if($post)
                        <a  href="{!! get_permalink($post) !!}"
                            class="single">
                            <figure>
                                <img
                                    class="lazy"
                                    src="{!! get_the_post_thumbnail_url($post->ID, 'medium') !!}"
                                    data-src="{!! get_the_post_thumbnail_url($post->ID, 'large') !!}"
                                />
                            </figure>
                            <p>{{ $post->post_title }}</p>
                        </a>
                    @endif
                @endforeach
            </div>
        </div>
    @endforeach
</div>