
const { __ } = wp.i18n

wp.domReady( () => {
    wp.blocks.unregisterBlockStyle('core/button', 'fill')
    wp.blocks.unregisterBlockStyle('core/button', 'outline')


    const el = wp.element.createElement;
    const SVG = wp.primitives.SVG;

    const iconColumnsCards = el(
      SVG, {
        width: 48,
        height: 48,
        viewBox: '0 0 48 48',
      },
      el('path', {
        fillRule: 'evenodd',
        clipRule: 'evenodd',
        d: 'M41 14a2 2 0 0 0-2-2H9a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h30a2 2 0 0 0 2-2V14zM28.5 34h-9V14h9v20zm2 0V14H39v20h-8.5zm-13 0H9V14h8.5v20z',
      })
    );

    wp.blocks.registerBlockStyle('core/buttons', {
      name: 'inline',
      label: 'Bottoni Inline',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'outline',
      label: 'Bottone Outline',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'fill',
      label: 'Bottone Pieno',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'arrow',
      label: 'Bottone con freccia',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'arrow-light',
      label: 'Bottone con freccia light',
    });

    wp.blocks.registerBlockStyle('core/button', {
      name: 'light',
      label: 'Bottone Light',
    });

    wp.blocks.registerBlockStyle('core/video', {
      name: 'black',
      label: 'Player Black',
    });

    wp.blocks.registerBlockStyle('core/video', {
      name: 'light',
      label: 'Player Light',
    });

    wp.blocks.registerBlockStyle('core/spacer', {
      name: 'big',
      label: 'Big (80px - mobile 60px)',
    });

    wp.blocks.registerBlockStyle('core/cover', {
      name: 'hero',
      label: 'Hero',
    });

    wp.blocks.registerBlockStyle('core/spacer', {
      name: 'medium',
      label: 'Medium (60px - mobile 30px)',
    });

});