import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar]);

export default (() => {
    window.addEventListener('load', function () {
      const decorsList = new Swiper('.decors-list .decors', {
        freeMode: true,
        freeModeSticky: true,
        slidesPerView: 2.2,
        spaceBetween: 16,
        scrollbar: {
          draggable: false,
        },
        navigation: {
          nextEl: '.decors-list .decors .swiper-button-next',
          prevEl: '.decors-list .decors .swiper-button-prev',
        },
        breakpoints: {
          768: {
            slidesPerView: 3,
            spaceBetween: 32,
          },
          1024: {
            slidesPerView: 4,
          },
        },
      });
    })
})()