@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');
  $teaser = get_field('teaser');
  $columns = get_field('columns');

  $args = array(
      'post_type' => 'downloads',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'taxonomy':
            $taxonomy = get_field('taxonomy');
            $args['tax_query'][] = 
                [
                    'taxonomy' => 'downloads-category',
                    'terms' => $taxonomy,
                ];

            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break; 

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} downloads-list">
     <div class="hidden lg:grid-cols-4 lg:grid-cols-3 lg:grid-cols-2 lg:grid-cols-1"></div>

    <div class="gap-8 grid grid-cols-1 md:grid-cols-2 {{ $columns }}">
        @php
            global $post;
        @endphp
        @foreach($posts as $key => $post)
            <div>
                @include('partials.teaser-' . get_post_type($post), ['type' => $teaser, 'post' => $post])
            </div>
        @endforeach
    </div>
</div>
