<article {!! post_class('single-product') !!}>
  <div class="container">
    @php
        $description = get_field('description');
        $title_extended = get_field('title_extended');

        $gallery = get_field('gallery');

        $specifications = get_field('specifications');
        $characteristics = get_field('characteristics');
        $applications = get_field('applications');
        $sheet = get_field('sheet');

        $finitures = get_field('finitures');
        $tints = get_field('tints');
        $properties = get_field('properties');

        $sheet_download = get_field('link', $sheet[0]->ID);
        $sheet_description = get_field('description', $sheet[0]->ID);
    @endphp
    @include('partials/page-header', ['is_product' => true, 'title_extended' => $title_extended])
    <div class="post-content-wrapper">
      <div class="gallery">
        <div class="flex flex-wrap gap-8 -mx-4">
            @foreach($gallery as $image)
                <div class="w-full sm:w-1/2 lg:w-1/4">
                    <figure class="bg-transparent">
                        <img class="object-contain" src="{!! $image['url'] !!}"/>
                    </figure>
                </div>
            @endforeach
        </div>
      </div>
      <div class="cheat-sheet">
          @if($specifications)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Informazioni tecniche','thor') !!}
                    </h6>
                </div>
                <div class="content">
                    {!! $specifications !!}
                </div>
            </div>
          @endif
          @if($applications)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Applicazioni','thor') !!}
                    </h6>
                </div>
                <div class="content">
                    {!! $applications !!}
                </div>
            </div>
          @endif
          @if($characteristics)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Caratteristiche','thor') !!}
                    </h6>
                </div>
                <div class="content">
                    {!! $characteristics !!}
                </div>
            </div>
          @endif
          @if($finitures)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Finiture','thor') !!}
                    </h6>
                </div>
                <div class="flex flex-wrap w-full -mx-2 lg:-mx-4 lg:gap-y-8 gap-y-4 content">
                  @foreach($finitures as $finiture)
                    <div class="w-1/2 lg:w-1/4 xl:w-1/6">
                      @include('partials.teaser-sheet', ['post' => $finiture])
                    </div>
                  @endforeach
                </div>
            </div>
          @endif
          @if($tints)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Tinte','thor') !!}
                    </h6>
                </div>
                <div class="flex flex-wrap w-full -mx-2 lg:-mx-4 lg:gap-y-8 gap-y-4 content">
                  @foreach($tints as $tint)
                    <div class="w-1/2 lg:w-1/4 xl:w-1/6">
                      @include('partials.teaser-sheet', ['post' => $tint])
                    </div>
                  @endforeach
                </div>
            </div>
          @endif
          @if($properties)
            <div class="single-sheet">
                <div class="title">
                    <h6>
                        {!! __('Proprietà','thor') !!}
                    </h6>
                </div>
                <div class="flex flex-wrap w-full -mx-2 lg:-mx-4 lg:gap-y-8 gap-y-4 content">
                  @foreach($properties as $property)
                    <div class="w-1/2 lg:w-1/4 xl:w-1/6">
                      @include('partials.teaser-sheet', ['post' => $property])
                    </div>
                  @endforeach
                </div>
            </div>
          @endif
          @if($sheet)
            <div class="single-sheet download">
                <div class="title">
                    <h6>
                        {!! __('Download','thor') !!}
                    </h6>
                </div>
                <a 
                href="{!! $sheet_download['url'] !!}"
                target="{!! $sheet_download['target'] !!}"
                title="{!! $sheet_download['title'] !!}"
                class="content download">
                    <div>
                        {!! $sheet_description !!}
                    </div>
                    <div>
                        @svg('images/arrow-down.svg')
                    </div>
                    </a>
            </div>
          @endif
      </div>
    </div>
  </div>
  <div class="related white">
    <h3>{!! __('Altri prodotti', 'thor') !!}</h3>
      @php
        $terms = get_the_terms($post, 'product-collection');
        $args = [
          'numberposts' => 3,
          'post_type' => 'product',
          'tax_query' => array(
                array(
                    'taxonomy' => 'product-collection',
                    'field'    => 'id',
                    'terms'    => $terms[0]->term_id,
                ),
            ),
          'exclude' => array(get_the_ID()),
        ];
        $posts = get_posts($args);
      @endphp
    @php
      global $post;
    @endphp
    <div class="container mx-auto">
      <div class="flex flex-wrap -mx-4 gap-y-15">
        @foreach($posts as $key => $post)
        <div class="w-1/2 lg:w-1/4">
          @include('partials.teaser-'.get_post_type($post))
        </div>
        @endforeach
      </div>
    </div>
  </div>
</article>
