import videojs from 'video.js/dist/alt/video.novtt'

export default (() => {
    window.addEventListener('load', () => {
        const videos = document.querySelectorAll('.wp-block-video')
    
        videos.forEach(function (el) {
            if(el.classList.contains('is-style-black') || el.classList.contains('is-style-light')) {
                const videoElement = el.querySelector('video')
                const source = videoElement.getAttribute('src')
                const createSource = document.createElement('source')
                createSource.setAttribute('src', source)
                videoElement.appendChild(createSource)

                videoElement.classList.add('custom-video')
                videoElement.classList.add('vjs-has-started')
                videoElement.classList.add('video-js')

                let player = videojs(videoElement, {
                    'preload': 'auto',
                    controlBar: {
                        volumePanel: {
                            inline: false,
                        },
                    },
                })
            }
        })
    })

})()