@php
  $grid = $_GET['grid'] ? : 'small';
@endphp

@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = get_field('archive_decor_subtitle','option');
      $count = 0;
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])
    @include('partials.filter-buttons', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'not_queryable' => false])

    <div class="flex flex-col list">
      @if (!have_posts())
      @else
        <div class="flex flex-wrap order-2 -mx-2 md:-mx-4 gap-y-4 lg:gap-y-8">
          @php
            global $post;
          @endphp
          @while (have_posts()) @php the_post() @endphp
          @php $count++; @endphp
              <div class="w-full px-2 md:px-4 @if($grid == 'large') w-full lg:w-1/2 @else w-1/2 lg:w-1/4 @endif">
                @include('partials.teaser-'.get_post_type())
              </div>
          @endwhile
        </div><!--row-->
      @endif
      @include('partials.decor.decor-single-panel', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'count' => $count])
      @include('partials.decor.decor-single-filter', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'count' => $count])
    </div>

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
