@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = get_field('archive_collection_subtitle','option');
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])

    @if (!have_posts())
    @else
      <div class="flex flex-wrap -mx-4 gap-y-15">
        @while (have_posts()) @php the_post() @endphp
          @php 
            $is_highlighted = get_field('is_highlighted');
          @endphp
          @if($is_highlighted)
            <div class="w-full is-highlighted">
          @else
            <div class="w-full lg:w-1/2 sm:w-1/2">
          @endif
              @include('partials.teaser-'.get_post_type())
            </div>
        @endwhile
      </div><!--row-->
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
