@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');

  $args = array(
      'post_type' => 'investor',
      'numberposts' => $how_much,
  );

  $teaser = get_field('teaser');
  $split_subcategories = get_field('split_subcategories');
  $show_anchors = get_field('show_anchors');

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'taxonomy':
            if(!$split_subcategories) {
                $taxonomy = get_field('taxonomy');
                $args['tax_query'][] = 
                    [
                        'taxonomy' => 'investors-category',
                        'terms' => $taxonomy,
                    ];
                $posts = get_posts($args);
            } else {
                $taxonomy = get_field('taxonomy');
                $taxonomy_data = get_term($taxonomy, 'investors-category');
                $terms = get_term_children( $taxonomy, 'investors-category' );
            }

          break;

      case 'specific':
            $posts = get_field('specific');
          break; 

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} investor-list">
    <div class="gap-8 w-full{{ $columns }}">
        @php
            global $post;
        @endphp
        @if(!$split_subcategories)
            <div class="mt-15">
                @foreach($posts as $key => $post)
                    <div>
                        @include('partials.teaser-' . get_post_type($post), ['type' => $teaser, 'post' => $post])
                    </div>
                @endforeach
            </div>
        @else
            @if($show_anchors)
                <div class="button-wrapper">
                    @foreach($terms as $key => $term)
                        @php
                            $term_data = get_term($term, 'investors-category');
                        @endphp
                        <a href="#{{ $taxonomy_data->slug . '-' . $term_data->slug }}" class="button outlined @if(get_queried_object() == $term_data)current @endif">
                            {!! $term_data->name !!}
                        </a>
                    @endforeach
                </div>
            @endif
            @foreach($terms as $key => $term)
                @php
                    $term_data = get_term($term, 'investors-category');
                    $term_data = get_term($term, 'investors-category');
                    $args['tax_query'] = [
                        [
                            'taxonomy' => 'investors-category',
                            'field' => 'term_id',
                            'terms' => $term,
                        ]
                    ];
                    $posts = get_posts($args);
                @endphp
                @if($posts)
                    <div class="single">
                        <h3 id="{!! $taxonomy_data->slug . '-' . $term_data->slug  !!}" class="title">
                            {!! $term_data->name !!}
                        </h3>
                    @foreach($posts as $key => $post)
                        <div class="-mx-4">
                            @include('partials.teaser-' . get_post_type($post), ['type' => $teaser, 'post' => $post])
                        </div>
                    @endforeach
                    </div>
                @endif
            @endforeach
        @endif
    </div>
</div>
