@php
    $link = get_field('link', $post);
    $show_hour = get_field('show_hour', $post);
@endphp

<article {{post_class('teaser-investor ' . $teaser)}}>
    @if($link)
        <a  class="wrapper"
            href="{!! $link['url'] !!}"
            target="{!! $link['target'] !!}">
    @else
        <a class="wrapper without-link">
    @endif
        <div>
            @if($show_hour)
                <div class="time"
                    datetime="{{ get_post_time('c', true) }}">
                        {{ get_the_date('d.m.Y (\HH.m)') }}
                </div>
            @else
                <div class="time"
                    datetime="{{ get_post_time('c', true) }}">
                        {{ get_the_date('d.m.Y') }}
                </div>
            @endif
                <div class="title">
                    {!! get_the_title($post) !!}
                </div>
        </div>

        @if($teaser != 'event')
            <div class="icon">
                @svg('images/arrow-down.svg')
            </div>
        @endif
    </a>
</article>