<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function human_filesize($bytes, $decimals = 1){
        $sz = 'BKMGTP';
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
    }

    public static function get_decors_filter_by_name ($filter) {
        $posts = [];

        foreach($filter as $single) {
            $posts[] = get_field($single);
        }

        return $posts;
    }


    public static function remove_single_query_arg($slug, $filter) {
        $query = $_GET[$slug];
        $query_updated = array_diff($query, array($filter));

        if(is_array($query)) {
            $url = remove_query_arg($slug);
            $url = add_query_arg($slug, $query_updated);
        } else {
            $url = remove_query_arg($slug);
        }

        return $url;
    }

    public static function cast_bool_taxonomy_term ($taxonomy, $term) {
        $cast_taxonomy = [
            'metallic_effect',
            'touch_effect'
        ];

        if(in_array($taxonomy, $cast_taxonomy)) {
            if($term == 0) { return __('No', 'thor'); }
            return __('Sì', 'thor');
        }

        return null;
    }


    public static function get_decor_taxonomies($filter = false) {
        if($filter != true) {
            $taxonomies = [
                'decors-category'             => __('Categoria decori', 'thor'),
                'development'                 => __('Sviluppo', 'thor'),
                'maximum_print_height'         => __('Massima Altezza di stampa', 'thor'),
                'number_of_cylinders'         => __('Numero di Cilindri', 'thor'),
                'metallic_effect'             => __('Effetto Metallico', 'thor'),
                'touch_effect'                => __('Touch Effect', 'thor'),
            ];
        } else {
            $taxonomies = [
                'features'                    => __('Caratteristiche', 'thor'),
                'development'                 => __('Sviluppo', 'thor'),
                'maximum_print_height'        => __('H max di stampa', 'thor'),
                'number_of_cylinders'         => __('Cilindri', 'thor'),
                'metallic_effect'             => __('Effetto Metallico', 'thor'),
                'touch_effect'                => __('Touch Effect', 'thor'),
            ];      
        }

        return $taxonomies;
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'thor');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Risultati per \'%s\'', 'thor'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'thor');
        }
        return get_the_title();
    }

    public static function get_block_info($block) {
        $id = 'thor-' . $block['slug'] . '-' . $block['id'];

        if (!empty($block['anchor'])) {
            $id = $block['anchor'];
        }

        $className = 'thor-' . $block['slug'];
        if (!empty($block['className'])) {
            $className .= ' container ' . $block['className'];
        }

        if (!empty($block['align'])) {
            $className .= ' align' . $block['align'];
        }

        return array('id' => esc_attr($id), 'classes' => esc_attr($className));
    }

    public function credits()
    {
        return __('Designed and developed by <a href="https://dueper.net" target="_blank">Dueper Design</a>', 'thor');
    }
}
