import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar]);

export default (() => {
    window.addEventListener('load', function () {
      const decorsList = new Swiper('.decor-list .decor', {
        freeMode: true,
        freeModeSticky: true,
        slidesPerView: 2.2,
        spaceBetween: 16,
        scrollbar: {
          draggable: false,
        },
        navigation: {
          nextEl: '.decor-list .decor .swiper-button-next',
          prevEl: '.decor-list .decor .swiper-button-prev',
        },
        breakpoints: {
          768: {
            slidesPerView: 3,
            spaceBetween: 32,
          },
          1024: {
            slidesPerView: 4,
          },
        },
      });
    })
})()