import gsap from 'gsap'
import zoom from 'jquery-zoom'
import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar, EffectFade } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, EffectFade]);

export default (() => {
    const decorSingle = document.querySelector('.decor-single')

    if(decorSingle) {
        const icons = decorSingle.querySelectorAll('.icons .icon, .zoom-decor .icon')
        const dataDecor = decorSingle.querySelectorAll('[data-decor]')
    
        icons.forEach(icon => {
            icon.addEventListener('click', (i) => {
                const dataIcon = icon.dataset.decor
                changeDecor(dataIcon)
            })
        })

        const development = document.querySelectorAll('.zoom-development .development')
        $(development).zoom({
            magnify: 2,
        })

        function changeDecor(dataIcon) {
            icons.forEach(icon => {
              icon.classList.remove('active')
              if (icon.dataset.decor == dataIcon) {
                icon.classList.add('active')
              }
            })
    
            dataDecor.forEach(data => {
                data.classList.remove('active')
                if(data.dataset.decor == dataIcon) {
                    data.classList.add('active')
                }
            })
        }

        const highlight = decorSingle.querySelector('.images .highlight')
        const close = decorSingle.querySelector('.zoom [data-close]')
        let zoom = decorSingle.querySelector('.zoom')

        highlight.addEventListener('click', () => {
            zoom.classList.add('active')
        })

        close.addEventListener('click', () => {
            zoom.classList.remove('active')
        })

        const highlightGallery = decorSingle.querySelectorAll('.decors-use figure')
        const closeGallery = decorSingle.querySelector('.gallery-use [data-close]')
        let zoomGallery = decorSingle.querySelector('.gallery-use')

        highlightGallery.forEach(single => {
            single.addEventListener('click', () => {
                zoomGallery.classList.add('active')
            })
        })

        closeGallery.addEventListener('click', () => {
            zoomGallery.classList.remove('active')
        })

        window.addEventListener('load', () => {
            const gallery = new Swiper('.gallery-use .inner', {
                navigation: {
                    nextEl: '.gallery-use .swiper-button-next',
                    prevEl: '.gallery-use .swiper-button-prev',
                },
                scrollbar: {
                    draggable: false,
                },
                effect: 'fade',
                fadeEffect: {
                    crossFade: true,
                },
            });
        })
    }
})()
