export default (() => {
    const headerPanel = document.querySelectorAll('.header-panel')
    const header = document.querySelector('.main-header')
    const menuItem = header.querySelectorAll('li a[data-id]')

    window.addEventListener('load', () => {
        headerPanel.forEach(panel => {
            const elements = panel.querySelectorAll('.links .link')
            elements.forEach(link => {
                link.addEventListener('mouseenter', () => {
                    toggleTeaser(link, panel, 'add')
                })

                link.addEventListener('mouseleave', () => {
                    toggleTeaser(link, panel)
                })
            })
        })

        function toggleTeaser(link, panel, action) {
            const teaser = header.querySelectorAll('.teaser')
            const currentLink = link.dataset.teaser

            teaser.forEach(single => {
                if (currentLink == single.dataset.teaser) {
                    if(action == 'add') {
                        single.classList.add('active')
                    } else {
                        single.classList.remove('active')
                    }
                }
            })
        }


        menuItem.forEach(toggle => {
            const dataTeaser = toggle.dataset.teaser

            const teaser = header.querySelectorAll('.teaser')
            teaser.forEach(single => {
                if (dataTeaser == single.dataset.teaser) {
                    single.classList.add('active')
                }
            })

            toggle.addEventListener('click', (e) => {
                e.preventDefault()
                const dataID = toggle.dataset.id
                menuElementActive(toggle)
                togglePanel(dataID)
            })
        })
    })

    function menuElementActive (toggle) {
        menuItem.forEach(item => {
            if (item != toggle) {
            item.classList.remove('active')
            }
        })
        if (toggle.classList.contains('active')) {
            toggle.classList.remove('active')
        } else {
            toggle.classList.add('active')
        }
    }

    function togglePanel (dataID) {
        let previouslyActive = closeOthers(dataID)
        headerPanel.forEach(panel => {
            const innerHeight = panel.querySelector('.inner').offsetHeight
            const columns = panel.querySelector('.columns')
            if(previouslyActive == true) {
                var timeout = 650
            } else {
                var timeout = 0
            }

            if(dataID == panel.dataset.id) {
                if(!panel.classList.contains('active')) {
                    setTimeout(() => {
                        panel.style.height = innerHeight + 'px'
                        setTimeout(() => {
                            columns.style.opacity = 1
                        }, 400);
                    }, timeout);
                    panel.classList.add('active')
                } else {
                    panel.style.height = 0
                    columns.style.opacity = 0
                    panel.classList.remove('active')
                }
            }
        })
    }

    function closeOthers(dataID) {
        let active = false
        headerPanel.forEach(panel => {
            const columns = panel.querySelector('.columns')
            if (panel.classList.contains('active') && dataID != panel.dataset.id) {
                active = true
                panel.style.height = 0
                columns.style.opacity = 0
                panel.classList.remove('active')
            }
        })

        return active
    }
})()