import {get} from 'axios'
export default (() => {
    const header = document.querySelector('.main-header')

    const searchDropdown = header.querySelector('.search-dropdown')
    const searchToggle = header.querySelector('.search-toggle')
    const searchModal = header.querySelector('.search-modal')
    const overlaySearch = header.querySelector('.overlay-search')
    

    window.addEventListener('load', () => {
        transitionEnter(searchDropdown, searchModal)
    })

    const input = searchModal.querySelector('.search-field')

    function transitionEnter (element, children) {
        const height = getComputedStyle(element).height;

        element.style.position = null;
        element.style.top = 'unset';
        children.style.opacity = 0;
        element.style.height = 0;

        let active = false

        searchToggle.addEventListener('click', () => {
            if(active == false) {
                input.focus()
                element.style.height = height;
                element.style.opacity = 1;
                element.style.pointerEvents = 'auto';
                children.style.opacity = 1;
                children.classList.add('active');
                overlaySearch.classList.add('active')
                active = true
            } else {
                overlaySearch.classList.remove('active')
                element.style.pointerEvents = 'none';
                children.style.opacity = 0;
                children.classList.remove('active');
                element.style.height = 0;
                active = false
            }
        })
    }
})()