@php
  $block_info = App::get_block_info($block);
  $title = get_field('title');
  $description = get_field('description');
  $image = get_field('image');
  $link = get_field('link');
@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }}">

    @include('partials.teaser-card', ['title' => $title ?? '',
                                      'description' => $description ?? '',
                                      'image' => $image['url'] ?? '',
                                      'image_lazy' => $image['sizes']['large'] ?? '',
                                      'image_title' => $image['title'] ?? '',
                                      'link' => $link['url'] ?? '',
                                      'target' => $link['target'] ?? ''])
</div>