@php


    if($is_category) {
        $terms = get_categories($args);
            $args = [
                'hide_empty' => true
            ];
    } else {
        $args = [
            'hide_empty' => true,
            'taxonomy' => $taxonomy,
        ];

        $terms = get_terms($args);
    }

    if($not_queryable == true) {
        $current = $_GET[$taxonomy];
    } else {
        $current = get_queried_object()->slug;
    }

    $archive_link_active = true;

    foreach($terms as $term):
            if($current == $term->slug):
                $archive_link_active = false;
            endif;
    endforeach;
@endphp

@if($terms)
    <div class="button-wrapper">
        <a class="button outlined @if($archive_link_active) current @endif" href="{!! add_query_arg( 'grid', $_GET['grid'], get_post_type_archive_link($post_type)) !!}">
            {!! __('Vedi tutti', 'thor') !!}
        </a>
        @foreach($terms as $key => $term)
            @php
                if($not_queryable) {
                    $link = add_query_arg( $taxonomy, $term->slug);
                    $current = $_GET['decors-category'];
                } else {
                    $link = get_category_link($term) ? get_category_link($term) : get_term_link($term, $post_type);
                }
            @endphp
            <a href="{{ $link }}" class="button outlined @if($current == $term->slug)current @endif">
                {!! $term->name !!}
            </a>
        @endforeach
    </div>
@endif