@php
    if($panel != 'none' && $panel) {
        if($panel == 'decors') {
            $fields = [
                1 => [
                    'title',
                    'links',
                    'see_all'
                    ],
                2 => [
                    'categories',
                ],
            ];
        } else {
            $fields = [
                1 => [
                    'title',
                    'links',
                    'see_all'
                    ],
                2 => [
                    'title',
                    'links',
                    'see_all'
                    ],
                3 => [
                    'title',
                    'links',
                    'see_all'
                    ],
            ];
        }
    }

    if($fields) {
        foreach($fields as $key => $menu) {
            foreach($menu as $field) {
                $data[$key][$field] = get_field($panel . '_' . $key . '_' . $field, 'option');
            }
        }
    }

@endphp

@if($data)
    <div data-id="{!! $menu_id !!}" class="header-panel {!! $panel !!}">
        <div class="inner">
            <div class="columns">
                @foreach($data as $column => $values)
                        @php
                            $title = $values['title'];
                            $links = $values['links'];
                            $see_all = $values['see_all'];
                        @endphp
                    @if($title or $links or $see_all)
                        <div class="column">
                            <h6>{!! $title !!}</h6>
                            <div class="links">
                                @if($links)
                                    @foreach($links as $position => $link)
                                        <a
                                            href="{!! $link['link']['url'] !!}"
                                            data-teaser={!! $column . '-' . $position !!}
                                            target="{!! $link['link']['target'] !!}"
                                            class="link">
                                            {!! $link['link']['title'] !!}
                                        </a>
                                    @endforeach
                                @endif
                            </div>
                            @if($see_all)
                                <div>
                                    <a  href="{!! $see_all['url'] !!}"
                                        target="{!! $see_all['target'] !!}"
                                        class="text-xs uppercase button arrow light">
                                        {!! $see_all['title'] !!}
                                        @svg('images/arrow-right.svg')
                                    </a>
                                </div>
                            @endif
                        </div>
                    @endif
                @endforeach
                <div class="column teasers">
                    <div class="inside">
                    @foreach($data as $column => $values)
                        @if($values)
                          @php
                            $links = $values['links'];
                            @endphp
                          @if($links)
                                @foreach($links as $position => $link)
                                @php
                                    $image = $link['image'];
                                    $title = $link['image_title'];
                                    $description = $link['image_description'];
                                @endphp 
                                    
                                    <div class="teaser"
                                         data-teaser={!! $column . '-' . $position !!}>
                                            <figure>
                                                <img src="{!! $image['url'] !!}"
                                                    title="{!! $image['title'] !!}" />
                                            </figure>
                                            <h4>{!! $title !!}</h4>
                                            <div>{!! $description !!}</div>
                                        </div>
                                @endforeach
                            @endif
                        @endif
                    @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif