<?php

namespace App;


add_action('add_meta_boxes', function () {
    $screens = ['decor'];
    foreach ($screens as $screen) {
        add_meta_box(
            'decor_pim_metabok',                 // Unique ID
            'Campi Decoro da PIM',      // Box title
            'App\decor_pim_metabox_callback',  // Content callback, must be of type callable
            $screen                            // Post type
        );
    }

    function decor_pim_metabox_callback($post) {
        $taxonomies = \App::get_decor_taxonomies();

        echo '<p style="font-weight: bold">'. __("Informazioni tecniche", "thor") .'</p>';
        foreach($taxonomies as $key => $taxonomy) {
            $term = get_the_terms($post, $key);
            $joined = '';

            if($term) {
                $joined = join(', ', wp_list_pluck($term, 'name'));
            }

                echo '<div>';
                echo '<span>'. sprintf($taxonomy . "%s", __(' : '),  ) .'</span>';
                echo '<span>'. $joined .'</span>';
                echo '</div>';
        }

        echo '<br>';
        echo '<br>';
        $tints = get_post_meta($post->ID, '_tinte', true);
        echo '<p style="font-weight: bold;">'. __("Tinte", "thor") .'</p>';
        if($tints) {
            foreach($tints as $key => $tint) {
                echo '<ul>';
                    echo '<li>';
                        echo '<img width="90" src="'. wp_get_attachment_url($tint['_immagine_di_anteprima_media_id']) .'"/>';
                        echo '<br/>';
                        echo '<span>'.$tint['_codice'].'</span>';
                    echo '</li>';
                echo '</ul>';
            }
        }

        echo '<br>';
        echo '<br>';

        echo '<p style="font-weight: bold">' . __("Informazioni di debug delle tinte", "thor") . '</p>';
        echo '<pre><code style="line-height: 1.7">' . json_encode($tints, JSON_PRETTY_PRINT) . '</code></pre>';
    }
});

add_action('pre_get_posts', function ($query) {
    if (!is_admin() && is_main_query() && (is_post_type_archive('decor') || is_tax('decors-category'))) {
        $taxonomies = \App::get_decor_taxonomies();

        $query->set('tax_query', [
            'relation' => 'AND',
        ]);
        foreach ($taxonomies as $taxonomy => $label) {
            if ($_GET[$taxonomy]) {
                $query->set(
                    'tax_query',
                    [
                        [
                            'taxonomy' => $taxonomy,
                            'field'    => 'slug',
                            'relation' => 'or',
                            'terms'    => $_GET[$taxonomy],
                        ]
                    ]
                );
            }
        }

        if ($_GET['features']) {
            $query->set('tax_query', [
                [
                    'taxonomy' => 'features',
                    'field'    => 'slug',
                    'terms'    => $_GET['features'],
                ]
            ]);
        }

        $order = $_GET['order'];

        $query->set('orderby', 'name');
        $query->set('order', $order);
    }
});

add_filter("wpseo_breadcrumb_links", function ($links) {
    if (is_singular('product')) {
        $breadcrumbs = [];

        $breadcrumbs[] = [
            'url' => get_home_url(),
            'text' => 'Home',
        ];

        $terms = get_the_terms($post, 'product-collection');
        foreach ($terms as $term) {

            $breadcrumb_picker = get_field('breadcrumb_picker', $term);
            foreach ($breadcrumb_picker as $picker) {
                $url = get_permalink($picker);
                $title = get_the_title($picker);

                $breadcrumbs[] = [
                    'url' => $url,
                    'text' => $title,
                ];
            }
        }

        $breadcrumbs[] = [
            'url' => get_permalink(),
            'text' => get_the_title(),
        ];

        return $breadcrumbs;
    }

    return $links;
});


/**
 * Add <body> classes
 */
add_filter('body_class', function (array $classes) {
    /** Add page slug if it doesn't exist */
    if (is_single() || is_page() && !is_front_page()) {
        if (!in_array(basename(get_permalink()), $classes)) {
            $classes[] = basename(get_permalink());
        }
    }

    /** Add class if sidebar is active */
    if (display_sidebar()) {
        $classes[] = 'sidebar-primary';
    }

    /** Clean up class names for custom templates */
    $classes = array_map(function ($class) {
        return preg_replace(['/-blade(-php)?$/', '/^page-template-views/'], '', $class);
    }, $classes);

    return array_filter($classes);
});

/**
 * Add "… Continued" to the excerpt
 */
add_filter('excerpt_more', function () {
    return ' &hellip; <a href="' . get_permalink() . '">' . __('Continued', 'thor') . '</a>';
});

/**
 * Template Hierarchy should search for .blade.php files
 */
collect([
    'index', '404', 'archive', 'author', 'category', 'tag', 'taxonomy', 'date', 'home',
    'frontpage', 'page', 'paged', 'search', 'single', 'singular', 'attachment', 'embed'
])->map(function ($type) {
    add_filter("{$type}_template_hierarchy", __NAMESPACE__ . '\\filter_templates');
});

add_filter('get_the_archive_title', function ($title) {
    if (is_category()) {
        $title = single_cat_title('', false);
    } elseif (is_tag()) {
        $title = single_tag_title('', false);
    } elseif (is_author()) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif (is_tax()) { //for custom post types
        $title = sprintf(__('%1$s'), single_term_title('', false));
    } elseif (is_post_type_archive()) {
        $title = post_type_archive_title('', false);
    }
    return $title;
});

/**
 * Render page using Blade
 */
add_filter('template_include', function ($template) {
    collect(['get_header', 'wp_head'])->each(function ($tag) {
        ob_start();
        do_action($tag);
        $output = ob_get_clean();
        remove_all_actions($tag);
        add_action($tag, function () use ($output) {
            echo $output;
        });
    });
    $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
        return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    if ($template) {
        echo template($template, $data);
        return get_stylesheet_directory() . '/index.php';
    }
    return $template;
}, PHP_INT_MAX);

/**
 * Render comments.blade.php
 */
add_filter('comments_template', function ($comments_template) {
    $comments_template = str_replace(
        [get_stylesheet_directory(), get_template_directory()],
        '',
        $comments_template
    );

    $data = collect(get_body_class())->reduce(function ($data, $class) use ($comments_template) {
        return apply_filters("sage/template/{$class}/data", $data, $comments_template);
    }, []);

    $theme_template = locate_template(["views/{$comments_template}", $comments_template]);

    if ($theme_template) {
        echo template($theme_template, $data);
        return get_stylesheet_directory() . '/index.php';
    }

    return $comments_template;
}, 100);


if (function_exists('get_field')) {
    add_filter(
        'mime_types',
        function ($mimes) {
            $mimes['json'] = 'application/json';
            $mimes['json'] = 'text/plain';
            $mimes['svg'] = 'image/svg+xml';
            return $mimes;
        }
    );
}
