import Lottie from 'lottie-web/build/player/lottie_light.min.js'
import gsap from 'gsap'
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger)

export default (() => {
    const animations = document.querySelectorAll('.lottie-animation .wrapper')
    animations.forEach(animation => {
        if(animation.dataset.animation) {
            const activateOnScroll = animation.dataset.activate
            console.log(activateOnScroll)
            let autoplay = activateOnScroll ? false : true

            let anim = Lottie.loadAnimation({
                container: animation,
                renderer: 'svg',
                loop: true,
                autoplay: autoplay,
                path: animation.dataset.animation,
            });

            if(activateOnScroll) {
                ScrollTrigger.create({
                    trigger: animations,
                    markers: true,
                    end: 'bottom start',
                    start: 'start bottom',
                    onEnter: () => {
                        anim.play()
                    },
    
                    onLeave: () => {
                        anim.stop()
                    },
    
                    onEnterBack: () => {
                        anim.play()
                    },
    
                    onLeaveBack: () => {
                        anim.stop()
                    },
                })
            }
        }
    })
})()