import Swiper from 'swiper';
import SwiperCore, { Navigation, Pagination, Scrollbar, EffectFade } from 'swiper/core';

SwiperCore.use([Navigation, Pagination, Scrollbar, EffectFade]);

export default (() => {
  const decorSingle = document.querySelector('.decor-single')

  if (decorSingle) {
    const highlight = decorSingle.querySelector('.images .highlight')
    const close = decorSingle.querySelector('.zoom [data-close]')
    let zoom = decorSingle.querySelector('.zoom')

    highlight.addEventListener('click', () => {
      zoom.classList.add('active')
    })

    close.addEventListener('click', () => {
      zoom.classList.remove('active')
    })

    const highlightGallery = decorSingle.querySelectorAll('.decors-use figure')
    const closeGallery = decorSingle.querySelectorAll('.gallery-use [data-close]')
    let zoomGallery = decorSingle.querySelector('.gallery-use')

    highlightGallery.forEach(single => {
      single.addEventListener('click', () => {
        zoomGallery.classList.add('active')
      })
    })

    closeGallery.forEach(single => {
      single.addEventListener('click', () => {
        zoomGallery.classList.remove('active')
      })
    })

    window.addEventListener('load', () => {
      const galleries = document.querySelectorAll('.gallery-use .inner')
      galleries.forEach(single => {
        single.classList.add('initialize')
        let singlePrev = single.querySelector('.swiper-button-prev')
        let singleNext = single.querySelector('.swiper-button-next')
        const gallery = new Swiper(single, {
          navigation: {
            nextEl: singleNext,
            prevEl: singlePrev,
          },
          scrollbar: {
            draggable: false,
          },
          effect: 'fade',
          fadeEffect: {
            crossFade: true,
          },
        });
        single.classList.remove('initialize')
      })
    })
  }

})()
