@extends('layouts.app')

@section('content')
  <div class="container">
    @php
      $description = get_field('archive_decor_subtitle','option');
      $count = 0;
    @endphp
    @include('partials.page-header', ['is_archive' => true, 'description' => $description])
    @include('partials.filter-buttons', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'not_queryable' => false, 'only_parents' => true])

    <div class="flex flex-col list">
      @if (!have_posts())
      @else
        <div class="decors-container" data-default="grid-small">
          @php
            global $post;
          @endphp
          @while (have_posts()) @php the_post() @endphp
          @php $count++; @endphp
              <div class="w-full">
                @include('partials.teaser-'.get_post_type())
              </div>
          @endwhile
        </div><!--row-->
      @endif
      @include('partials.decor.decor-single-panel', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'count' => $count])
      @include('partials.decor.decor-single-filter', ['taxonomy' => 'decors-category', 'post_type' => 'decor', 'count' => $count])
    </div>

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
