@extends('layouts.app')

@section('content')
  <div class="container">
    @include('partials.page-header', ['is_blog' => true])
    @include('partials.filter-buttons', ['is_category' => true, 'post_type' => 'post'])

    @if (!have_posts())
    @else
      <div class="grid-list three">
        @while (have_posts()) @php the_post() @endphp
          @php 
            $is_highlighted = get_field('is_highlighted');
          @endphp
          @if($is_highlighted)
            <div class="w-full is-highlighted">
          @else
            <div class="w-full">
          @endif
              @include('partials.teaser-'.get_post_type(), ['show_date' => true, 'show_category' => true])
            </div>
        @endwhile
      </div><!--row-->
    @endif

    @if(function_exists('wp_pagenavi'))
      {!!  wp_pagenavi(); !!}
    @endif

  </div><!--container-->
@endsection
