@php
    if($is_category) {
        $terms = get_categories($args);
            $args = [
                'hide_empty' => true
            ];
    } else {
        $args = [
            'hide_empty' => true,
            'taxonomy' => $taxonomy,
        ];

        $terms = get_terms($args);
    }

    if($not_queryable == true) {
        $current = $_GET[$taxonomy];
    } else {
        $current = get_queried_object()->slug;
    }

    $archive_link_active = true;

    if($only_parents):
        $terms = array_filter($terms, function ($term) {
            return !$term->parent ? $term : null;
        });
    endif;

    if($only_queried_children):
        $terms = array_filter($terms, function ($term) {
            $current = get_queried_object()->term_id;
            if($term->parent == $current) {
                return $term;
            }
        });

        $archive_link_active = false;
    endif;

    foreach($terms as $term):
            if($current == $term->slug):
                $archive_link_active = false;
            endif;
    endforeach;
@endphp

<div class="button-wrapper">
    <a class="button outlined @if($archive_link_active) current @endif" href="{!! get_post_type_archive_link($post_type) !!}">
        {!! __('Vedi tutti', 'thor') !!}
    </a>
    @foreach($terms as $key => $term)
        @php
            if($not_queryable) {
                $link = add_query_arg( $taxonomy, $term->slug);
                $current = $_GET['decors-category'];
            } else {
                $link = get_category_link($term) ? get_category_link($term) : get_term_link($term, $post_type);
            }
        @endphp
        <a href="{{ $link }}" class="button outlined @if($current == $term->slug)current @endif">
            {!! $term->name !!}
        </a>
    @endforeach
</div>