<?php
namespace App;

function thor_blocks_callback($block, $content = '', $is_preview = false, $post_id = 0 ) {
  $slug = str_replace('acf/', '', $block['name']);
  $block['slug'] = $slug;
  $block['classes'] = implode(' ', [$block['slug'], $block['className'], 'align'.$block['align']]);
  $template = null;
  $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
    return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    
  $data['block'] = $block;
  $data['content'] = $content;
  $data['is_preview'] = $is_preview;
  $data['post_id'] = $post_id;
  echo \App\template("blocks/${slug}", $data);
}
// Register custom blocks
if( function_exists('acf_register_block_type') ) {

  add_action('init', function () {

    acf_register_block_type(array(
      'name'              => 'Decor List',
      'title'             => __('Decor List', 'thor'),
      'description'       => __('Custom block that shows a list of decors', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Decors list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Download List',
      'title'             => __('Download List', 'thor'),
      'description'       => __('Custom block that shows a list of Download', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Download list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'lottie-animation',
      'title'             => __('Lottie animation', 'thor'),
      'description'       => __('Custom block that lets you use Lottie', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Animation', 'lottie', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Finitures List',
      'title'             => __('Finitures List', 'thor'),
      'description'       => __('Custom block that shows a list of Finitures', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Finitures list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Tints List',
      'title'             => __('Tints List', 'thor'),
      'description'       => __('Custom block that shows a list of Tints', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Tints list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Product List',
      'title'             => __('Product List', 'thor'),
      'description'       => __('Custom block that shows a list of Product', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Product list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Properties List',
      'title'             => __('Properties List', 'thor'),
      'description'       => __('Custom block that shows a list of Properties', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Properties list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Investor List',
      'title'             => __('Investor List', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Investor list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Pie Chart',
      'title'             => __('Pie Chart', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Pie Chart', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Person',
      'title'             => __('Person', 'thor'),
      'description'       => __('Custom block that shows a list of Investor', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Person', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Timeline',
      'title'             => __('Timeline', 'thor'),
      'description'       => __('Custom block that shows a timeline', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M5 13.5h3v-3H5v3zm5 0h3v-3h-3v3zM17 9l-1 1 2 2-2 2 1 1 3-3-3-3z"></path></svg>',
      'keywords'          => array( 'Timeline', 'year', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Card',
      'title'             => __('Card', 'thor'),
      'description'       => __('Custom block that shows a card', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" aria-hidden="true" focusable="false"><path d="M18.5 5.5V8H20V5.5h2.5V4H20V1.5h-1.5V4H16v1.5h2.5zM12 4H6a2 2 0 00-2 2v12a2 2 0 002 2h12a2 2 0 002-2v-6h-1.5v6a.5.5 0 01-.5.5H6a.5.5 0 01-.5-.5V6a.5.5 0 01.5-.5h6V4z"></path></svg>',
      'keywords'          => array( 'Card', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Accordion wrapper',
      'title'             => __('Accordion Wrapper', 'thor'),
      'description'       => __('Insert the Accordion wrapper inside this block', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('posts', 'image', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),

        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Accordion Inner',
      'title'             => __('Accordion Inner', 'thor'),
      'description'       => __('Use this block inside an Accordion Wrapper', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => 'list-view',
      'keywords'          => array('posts', 'image', 'custom'),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),

        'mode' => false,
        '__experimental_jsx' => true,
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Gallery',
      'title'             => __('Gallery slider', 'thor'),
      'description'       => __('Custom block that shows a list of Gallery', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Gallery list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Animated values',
      'title'             => __('Value animation', 'thor'),
      'description'       => __('Animate a value', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Animated numbers', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

    acf_register_block_type(array(
      'name'              => 'Posts List',
      'title'             => __('Posts List', 'thor'),
      'description'       => __('Custom block that shows a list of Posts', 'thor'),
      'render_callback'   => 'App\\thor_blocks_callback',
      'category'          => 'thor-blocks',
      'icon'              => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="48" height="48" role="img" aria-hidden="true" focusable="false"><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-7.8 16.5H5c-.3 0-.5-.2-.5-.5v-6.2h6.8v6.7zm0-8.3H4.5V5c0-.3.2-.5.5-.5h6.2v6.7zm8.3 7.8c0 .3-.2.5-.5.5h-6.2v-6.8h6.8V19zm0-7.8h-6.8V4.5H19c.3 0 .5.2.5.5v6.2z" fill-rule="evenodd" clip-rule="evenodd"></path></svg>',
      'keywords'          => array( 'Posts List list', 'image', 'custom' ),
      'mode'              => 'edit',
      'supports'          => array(
        'mode'  => false,
        'align' => array(
          'left',
          'right',
          'full',
          'wide'
        ),
      ),
    ));

  }, 10);
}