import {gsap, Power1} from 'gsap'
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger)

export default (() => {
    const filterInspiration = document.querySelector('.filter-inspiration')

    if(filterInspiration) {
        window.addEventListener('load', () => {
            mobileFilterPosition()
            hideInspirationOnScroll()
        })

        window.addEventListener('resize', () => {
            mobileFilterPosition()
        })

        const singleFilter = filterInspiration.querySelectorAll('.inner')

        singleFilter.forEach((filter) => {
            const elements = filter.querySelectorAll('.single')

            elements.forEach(element => element.addEventListener('click', function () {
                toggleActive(elements, element)
                const newCode = calculateNewCode()
                changeRender(newCode)
            }))
        })
    
        function mobileFilterPosition () {
            if(window.innerWidth < 1024) {
                const height = - filterInspiration.offsetHeight
                const offset =  + 75
    
                filterInspiration.style.bottom = height + offset +'px'
    
                const chooseDecors = filterInspiration.querySelector('.choose-decors')
    
                const t1 = gsap.timeline()
                t1.fromTo(filterInspiration, {
                    bottom: height + offset,
                    ease: Power1.easeInOut,
                    duration: 0.4,
                }, {
                    bottom: 0,
                    ease: Power1.easeInOut,
                    duration: 0.4,
                })
    
                t1.pause()
    
                let active = false
                chooseDecors.addEventListener('click', () => {
                    if(active == false) {
                        filterInspiration.classList.add('active')
                        t1.play()
                        active = true
                    } else {
                        filterInspiration.classList.remove('active')
                        t1.reverse()
                        active = false
                    }
                })
            } else {
                filterInspiration.style.bottom = 0
            }
        }

        function hideInspirationOnScroll () {
            const sectionFocus = document.querySelector('.focus')

            ScrollTrigger.create({
              trigger: sectionFocus,
              start: 'top bottom',
              end: 'top bottom',
              onEnter: () => {
                  if(window.innerWidth > 1023) {
                      gsap.to(filterInspiration, {
                        y: filterInspiration.offsetHeight,
                        duration: 0.3,
                      })
                  } else {
                    gsap.to(filterInspiration, {
                        y: 75,
                        duration: 0.3,
                    })
                  }
              },
              onEnterBack: () => {
                gsap.to(filterInspiration, {
                    y: 0,
                    duration: 0.3,
                })
              },
            });
        }
    
        function toggleActive (elements, element) {
            if (element.dataset.active) {
                element.removeAttribute('data-active')
            } else {
                elements.forEach(single => {
                    single.removeAttribute('data-active')
                });
    
                element.setAttribute('data-active', '')
            }
        }
    
        function calculateNewCode() {
            const activeElements = filterInspiration.querySelectorAll('.single[data-active]')
            let activeCode = []
            activeElements.forEach((element, index) => {
                if(index != 0) {
                    activeCode.push('_')
                }
                activeCode.push(element.dataset.filterIndex)
            })
    
            return ''.concat(...activeCode)
        }
    
        function changeRender(code) {
            const singleInspiration = document.querySelector('.single-inspiration')
    
            const renders = singleInspiration.querySelectorAll('.renders img')
    
            renders.forEach((render) => {
                const index = render.dataset.renderIndex
                render.style.display = 'none'
    
                if(index == code) {
                    render.style.display = 'inline-block'
                }
            })
        }
    }
})()