@php
  $block_info = App::get_block_info($block);

  $filter = get_field('filter');
  $how_much = get_field('how_much');

  $args = array(
      'post_type' => 'property',
      'numberposts' => $how_much,
  );

  switch ($filter) {
      case 'last':
            $posts = get_posts($args);
          break;

      case 'specific':
            $posts = get_field('specific');
          break;

      default:
        break;
  }

@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} sheet-list">
    <div>
        <div class=" swiper-container sheet properties desktop">
            <div class="swiper-wrapper">
                @php
                    $count = count($posts);
                @endphp
                @foreach($posts as $key => $post)
                    <div class="swiper-slide">
                        <div class="single">
                            @include('partials.teaser-sheet', ['count' => $count, 'current' => $key +1])
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        <div class="grid-list four properties sheet mobile">
            @php
                $count = count($posts);
            @endphp
            @foreach($posts as $key => $post)
                <div class="w-full">
                    <div class="single">
                        @include('partials.teaser-sheet', ['count' => $count, 'current' => $key +1])
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
