<div
    class="decor-panel">
    <div class="inner">
        <div class="filters">
            <span>{!! __('Filtri', 'thor') !!}</span>
            @svg('images/more.svg')
        </div>
        <form method="get">
            <div class="decor-info">
                <div class="order-by">
                    <div class="single accordion-wrapper accordions">
                        <div class="accordion-single">
                            <div class="title">
                                <span>
                                    {!! __('Ordina per', 'thor') !!}
                                </span>
                                <div class="close">
                                    @svg('images/chevron-down.svg') 
                                </div>
                            </div>
                            <div class="list content-accordion">
                                <div class="list-inside">
                                    <div class="term">
                                        @php
                                            $order = $_GET['order'] ? : 'DEF';
                                        @endphp
                                        <label for="DEF">{!! __('Default', 'thor') !!}</label>
                                        <input @if($order == 'DEF') checked @endif  type="radio" id="DEF" name="order" value="DEF">
                                    </div>
                                    <div class="term">
                                        <label for="ASC">{!! __('Nome in ordine alfabetico', 'thor') !!}</label>
                                        <input @if($order == 'ASC') checked @endif  type="radio" id="ASC" name="order" value="ASC">
                                    </div>
                                    <div class="term">
                                        <label for="DESC">{!! __('Nome in ordine inverso', 'thor') !!}</label>
                                        <input @if($order == 'DESC') checked @endif  type="radio" id="DESC" name="order" value="DESC">
                                    </div>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
                <div class="meta">
                    @php
                        $is_filter = true;
                        $taxonomies = App::get_decor_taxonomies($is_filter);
                    @endphp

                    @foreach($taxonomies as $slug => $label)
                        @php
                            $terms = get_terms($slug, [
                                'hide_empty' => true,
                            ]);


                            
                            if($_GET[$slug]) {
                                $current = preg_filter('/^/', $slug.'_', $_GET[$slug]);
                                $count = count($_GET[$slug]);
                            } else {
                                $count = 0;
                            }
                        @endphp
                        @if($terms)
                            <div class="single accordion-wrapper accordions @if($slug == 'features') features @endif">
                                <div class="accordion-single">
                                    <div class="title">
                                        <span>
                                            {!! $label !!}
                                            <span
                                                class="count">
                                                    @if($count > 0) 
                                                        {!! sprintf(__('(%s)'), $count) !!}
                                                    @endif
                                            </span>
                                        </span>
                                        @svg('images/chevron-down.svg') 
                                    </div>
                                    <div class="list content-accordion">
                                        <div class="list-inside">
                                            @foreach($terms as $key => $term)
                                            @php
                                                if($current) {
                                                    $is_checked = in_array($slug . '_' . $term->slug, $current);
                                                }
                                            @endphp
                                                <div class="term">
                                                    <label for="{!! $slug !!}_{!! $term->slug !!}">
                                                        <span>
                                                            @if(!App::cast_bool_taxonomy_term($slug, $term->slug))
                                                                {!! $term->name !!}
                                                            @else
                                                                {!! App::cast_bool_taxonomy_term($slug, $term->slug) !!}
                                                            @endif
                                                        </span>
                                                    </label>
                                                    <input @if($is_checked) checked @endif type="checkbox" id="{!! $slug . '_' . $term->slug !!}" name="{!! $slug !!}[]" value="{!! $term->slug !!}">
                                                </div>
                                            @endforeach
                                        </div>
                                    </div> 
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
                <div class="actions">
                    @if($_GET['decors-category'])
                        <input type="hidden" name="decors-category" value="{!! $_GET['decors-category'] !!}">
                    @endif
                    <input type="reset" value="{!! __('Cancella filtri', 'thor') !!}">
                    <input type="submit" value="{!! __('Applica', 'thor') !!}">
                </div>
            </div>
        </form>
    </div>
</div>