@if($content)
    <div class="single-sheet with-overlay">
        <div class="title">
            <h6>
                {!! $title !!}
            </h6>
        </div>
        <div class="grid-list six content">
            @foreach($content as $key => $finiture)
            <div class="w-full" @if($overlay )data-key="{!! $key !!} @endif">
                @include('partials.teaser-sheet', ['post' => $finiture])
            </div>
            @endforeach
        </div>
        @if($overlay)
            <div class="sheet-overlay">
                <div data-close>
                    @svg('images/close.svg')
                </div>
                <div class="swiper-container">
                    <div class="arrow-container">
                        <div class="swiper-button-prev">
                        @svg('images/arrow-left.svg')
                        </div>
                        <div class="swiper-button-next">
                        @svg('images/arrow-right.svg')
                        </div>
                    </div>
                    <div class="swiper-wrapper">
                    @foreach($content as $key => $finiture)
                        <div class="swiper-slide">
                        @php
                            $count = count($content);
                            $key++;
                            $overlay_image = get_field('overlay_image', $finiture) ? get_field('overlay_image', $finiture)['url'] : get_the_post_thumbnail_url($finiture->ID, 'full');
                        @endphp
                            <article {{post_class('teaser-' . get_post_type($finiture))}}>
                            <figure>
                                @if($overlay_image)
                                <img
                                    src="{!! $overlay_image !!}"
                                />
                                @endif
                            </figure>
                            <h3>
                                @if($count and $key)
                                    <span>{!! $key . '/' . $count . ' ' !!}</span>
                                @endif
                                {!! $finiture->post_title !!}
                            </h3>
                            </article>
                        </div>
                    @endforeach
                    </div>
                </div>
            </div>
        @endif
    </div>
@endif