@php
$args = array(
    'post_type' => 'post',
    'posts_per_page' => 4,
    's' => get_search_query(),
);

if($show_all) {
    $args['posts_per_page'] = 20;
}

$query = new WP_Query($args);
@endphp

@if($query->have_posts())
    <div class="results">
        <div class="title-results">
                <h3>
                    {!! __('News') !!}
                </h3>
            <span class="found-count">
                @php printf( __( '%s risultati', 'thor' ), $query->found_posts ) @endphp
            </span>
        </div>
        <div class="grid-list four">
            @while($query->have_posts()) @php $query->the_post() @endphp
                @php
                    global $post;
                @endphp
                <div class="w-full">
                    @include('partials.teaser')
                </div>
            @endwhile
        </div>
        @php 
            $all_link = add_query_arg( 'post_type', 'post', get_search_link() );
        @endphp

        @if(!$show_all)
            <a href="{!! $all_link; !!}">
                <button class="show-all">
                    {!! __('Vedi tutti i risultati', 'thor') !!}
                </button>
            </a>
        @else
            @if(function_exists('wp_pagenavi'))
                {!!  wp_pagenavi(); !!}
            @endif
        @endif
    </div>
@endif