import {gsap} from 'gsap'

export default (() => {
    const teaserPosts = document.querySelectorAll('.teaser-post, .teaser-inspiration')

    teaserPosts.forEach((teaser) => {
        const video = teaser.querySelector('video')
        let timelineVideo = gsap.timeline()

        if(video) {
            timelineVideo.to(video, {
                opacity: 1,
                duration: 0.2,
                onComplete: () => {
                    if (video) {
                        video.play()
                    }
                },
                onReverseComplete: () => {
                    if (video) {
                        video.pause()
                    }
                },
            })

            timelineVideo.pause()
    
            teaser.addEventListener('mouseenter', () => {
                timelineVideo.play()
            })
    
            teaser.addEventListener('mouseleave', () => {
                timelineVideo.reverse()
            })
        }
    })
})()