@php
if ($panel != 'none' && $panel) {
    if ($panel == 'decor') {
        $fields = [
            1 => ['title', 'links', 'see_all'],
            2 => ['categories'],
        ];
    } else {
        $fields = [
            1 => ['title', 'links', 'see_all'],
            2 => ['title', 'links', 'see_all'],
            3 => ['title', 'links', 'see_all'],
        ];
    }
}

if ($fields) {
    foreach ($fields as $key => $menu) {
        foreach ($menu as $field) {
            $data[$key][$field] = get_field($panel . '_' . $key . '_' . $field, 'option');
        }
    }
}

@endphp

@if ($data)
    <div data-id="{!! $menu_id !!}" class="header-panel {!! $panel !!}">
        <button class="close button arrow">
            @svg('images/arrow-left.svg')
            <span>{!! __('Back', 'thor') !!}</span>
        </button>
        <div class="inner">
            <div class="columns">
                @foreach ($data as $column => $values)
                    @php
                        $title = $values['title'];
                        $links = $values['links'];
                        $see_all = $values['see_all'];
                        $categories = $values['categories'];
                    @endphp
                    @if ($title or $links or $see_all)
                        <div class="column">
                            <h6>{!! $title !!}</h6>
                            <div class="links">
                                @if ($links)
                                    @foreach ($links as $position => $link)
                                        <a href="{!! $link['link']['url'] !!}" data-teaser={!! $column . '-' . $position !!}
                                            target="{!! $link['link']['target'] !!}" class="link">
                                            {!! $link['link']['title'] !!}
                                        </a>
                                    @endforeach
                                @endif
                            </div>
                            @if ($see_all)
                                <div>
                                    <a href="{!! $see_all['url'] !!}" target="{!! $see_all['target'] !!}"
                                        class="text-xs uppercase button arrow light">
                                        {!! $see_all['title'] !!}
                                        @svg('images/arrow-right.svg')
                                    </a>
                                </div>
                            @endif
                        </div>
                    @endif
                @endforeach
                @if ($panel === 'decor')
                    <div class="column category">
                        <h6>{!! __('Categories', 'thor') !!}</h6>
                        @php
                            $terms = get_terms('decors-category', [
                                'exclude' => $categories,
                            ]);
                        @endphp
                        <div class="links">
                            @if ($terms)
                                @foreach ($terms as $position => $term)
                                    @if (!$term->parent)
                                        <a href="{!! get_term_link($term, 'decors-category') !!}" data-category="{!! $term->term_id !!}"
                                            class="link">
                                            {!! $term->name !!}
                                        </a>
                                    @endif
                                @endforeach
                            @endif
                        </div>
                    </div>
                    <div class="column subcategory desktop">
                        @foreach ($terms as $key => $term)
                            @php
                                $children = get_term_children($term->term_id, 'decors-category');
                            @endphp
                                <div class="links" data-category="{!! $term->term_id !!}">
                                    @if ($children)
                                        <div class="mb-8">
                                            @foreach ($children as $key => $child)
                                                @php
                                                    $current = get_term($child, 'decors-category');
                                                @endphp
                                                <a href="{!! get_term_link($current, 'decors-category') !!}" data-category="{!! $current->term_id !!}"
                                                    class="link">
                                                    {!! $current->name !!}
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                    <a href="{!! get_term_link($term->term_id) !!}" class="link see-all">
                                        <span>{!! __('See all - ') . $term->name !!}</span>
                                        @svg('images/arrow-right.svg')
                                    </a>
                                </div>
                        @endforeach
                    </div>
                    @foreach ($terms as $key => $term)
                        @php
                            $children = get_term_children($term->term_id, 'decors-category');
                        @endphp
                        @if ($children)
                            <div class="column subcategory mobile" data-category="{!! $term->term_id !!}">
                                <button class="close button arrow">
                                    @svg('images/arrow-left.svg')
                                    <span>{!! __('Back', 'thor') !!}</span>
                                </button>
                                <div class="inner">
                                    <div class="links">
                                        <a class="link active">
                                            {!! $term->name !!}
                                        </a>
                                    </div>
                                    <div class="links">
                                        @foreach ($children as $key => $child)
                                            @php
                                                $current = get_term($child, 'decors-category');
                                            @endphp
                                            <a href="{!! get_term_link($current, 'decors-category') !!}" data-category="{!! $current->term_id !!}"
                                                class="link">
                                                {!! $current->name !!}
                                            </a>
                                        @endforeach
                                    </div>
                                    <a href="{!! get_term_link($term->term_id) !!}" class="link see-all">
                                        <span>{!! __('See all - ') . $term->name !!}</span>
                                        @svg('images/arrow-right.svg')
                                    </a>
                                </div>
                            </div>
                        @endif
                    @endforeach
                    <div class="column category-image">
                        @foreach ($terms as $key => $term)
                            @if (!$term->parent)
                                @php
                                    $category_image = get_term_meta($term->term_id, '_thumbnail_id', true);
                                @endphp
                                @if ($category_image)
                                    <a href="{!! get_term_link($term->term_id) !!}" class="links desktop"
                                        data-category="{!! $term->term_id !!}">
                                        <img src="{!! wp_get_attachment_url($category_image) !!}" />
                                        <span>{!! $term->name !!}</span>
                                    </a>
                                @endif
                            @endif
                        @endforeach
                    </div>
                @endif
                <div class="column teasers">
                    <div class="inside">
                        @foreach ($data as $column => $values)
                            @if ($values)
                                @php
                                    $links = $values['links'];
                                @endphp
                                @if ($links)
                                    @foreach ($links as $position => $link)
                                        @php
                                            $image = $link['image'];
                                            $title = $link['image_title'];
                                            $description = $link['image_description'];
                                        @endphp

                                        <div class="teaser" data-teaser={!! $column . '-' . $position !!}>
                                            <figure>
                                                <img src="{!! $image['url'] !!}" title="{!! $image['title'] !!}" />
                                            </figure>
                                            <h4>{!! $title !!}</h4>
                                            <div>{!! $description !!}</div>
                                        </div>
                                    @endforeach
                                @endif
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
