@php
    $link = get_the_permalink($post);
    $title_expanded = get_field('title_extended', $post);
@endphp

<article {{post_class('teaser teaser-' . get_post_type())}}>
    <a 
    class="is-card-layout"
    href="{!! $link !!}"
    target="{!! $target !!}">
        <figure>
            <img 
                class="lazy"
                src="{!! get_the_post_thumbnail_url($post, 'large') !!}"
                data-src="{!! get_the_post_thumbnail_url($post, 'full') !!}"/>
        </figure>
        <h2>{!! $post->post_title !!}</h2>
        <div>{!! $title_expanded !!}</div>
    </a>
</article>