@php
  $hover_type = get_field('hover_type');
  $content = get_field($hover_type) ? : 'image';
@endphp
<article {{post_class('teaser teaser-' . get_post_type())}}>
  @if($show_category)
    @php
      $categories = get_the_category();
    @endphp
    @if($categories)
      <div> 
      @foreach($categories as $key => $category)
        <a
          href="{!! get_category_link($category) !!}"
          class="category">
            {!! $category->name !!}
        </a>
      @endforeach
      </div>
    @endif
  @endif
  <a href="{!! get_permalink() !!}" title="{!! get_the_title() !!}">
    <figure>
      @if(get_the_post_thumbnail_url(get_the_ID(), 'full'))
        <img
          class="lazy"
          src="{!! get_the_post_thumbnail_url(get_the_ID(), 'large') !!}"
          data-src="{!! get_the_post_thumbnail_url(get_the_ID(), 'full') !!}"
        />
      @endif
        @if($hover_type == 'video')
          <video
              preload="meta"
              loop
              muted
              playsinline>
            <source src="{!! $content['url'] !!}" type="{!! $content['mime_type'] !!}" />
          </video>
        @endif
        @if($hover_type == 'image')
          <img 
            class="lazy hover" 
            data-src="{!! $content['url'] !!}"
            src="{!! $content['sizes']['large'] !!}" />
        @endif
      </figure>

    <header>
      @if($show_date)
        <div class="time"
            datetime="{{ get_post_time('c', true) }}">
          {{ get_the_date('d.m.Y') }}
        </div>
      @endif
        <h2>
          {!! get_the_title() !!}
        </h2>
    </header>
  </a>
</article>
