export default (() => {
  const headerPanel = document.querySelectorAll('.header-panel')
  const header = document.querySelector('.main-header')
  const menuItem = header.querySelectorAll('li a[data-id]')

  menuItem.forEach(toggle => {
    const dataTeaser = toggle.dataset.teaser
    const teaser = header.querySelectorAll('.teaser')
    teaser.forEach(single => {
      if (dataTeaser == single.dataset.teaser) {
        single.classList.add('active')
      }
    })

    toggle.addEventListener('click', (e) => {
      e.preventDefault()
      const dataID = toggle.dataset.id
      menuElementActive(toggle)
      togglePanel(dataID)
    })
  })

  headerPanel.forEach(panel => {
    const elements = panel.querySelectorAll('.links .link')
    const categoryElements = panel.querySelectorAll('.category .links .link')
    const closeButton = panel.querySelector('.close')

    closePanelWithButtonInside(closeButton, panel)

    categoryElements.forEach( link => {
        link.addEventListener('mouseenter', (event) => {
            const categoryID = link.dataset.category
            let hasClickedLinks = false
            categoryElements.forEach(link => {
                if (link.dataset.clicked) {
                    hasClickedLinks = true
                }
            })

            if(!hasClickedLinks) {
                toggleCategoryElements(categoryID, panel, event, link)
            }
        })

        link.addEventListener('click', (event) => {
            event.preventDefault()
            const categoryID = link.dataset.category
            categoryElements.forEach(linkToRemoveClick => {
                if(linkToRemoveClick !== link) {
                    linkToRemoveClick.removeAttribute('data-clicked')
                }
            })
            if(link.dataset.clicked) {
                link.removeAttribute('data-clicked')
            } else {
                link.setAttribute('data-clicked', true)
            }

            toggleCategoryElements(categoryID, panel, event)
        })
    })

    elements.forEach(link => {
      link.addEventListener('mouseenter', () => {
        toggleTeaser(link, panel, 'add')
      })

      link.addEventListener('mouseleave', () => {
        toggleTeaser(link, panel)
      })
    })
  })

  function closePanelWithButtonInside(closeButton, panel) {
    closeButton.addEventListener('click', () => {
        togglePanel(panel.dataset.id)
    })
  }

  function toggleCategoryElements(categoryID, panel, event) {

    const subcategoryElements = panel.querySelectorAll('.subcategory .links, .category-image .links, .subcategory.mobile')

    subcategoryElements.forEach(singleSubCategory => {
        closeMobile(singleSubCategory, panel)

        singleSubCategory.classList.remove('active')
        if(singleSubCategory.dataset.category == categoryID) {
            event.preventDefault()
            singleSubCategory.classList.add('active')
        }
    })
  }

  function closeMobile (singleSubCategory, panel) {
    const close = singleSubCategory.querySelector('.close')
    if(close) {
        close.addEventListener('click', () => {
            singleSubCategory.classList.remove('active')

            const categoryElements = panel.querySelectorAll('.category .links .link')
            categoryElements.forEach(category => {
                category.removeAttribute('data-clicked')
            })
        })
    }
  }

  function toggleTeaser(link, panel, action) {
    const teaser = header.querySelectorAll('.teaser')
    const currentLink = link.dataset.teaser

    teaser.forEach(single => {
      if (currentLink == single.dataset.teaser) {
        if (action == 'add') {
          single.classList.add('active')
        } else {
          single.classList.remove('active')
        }
      }
    })
  }

  function menuElementActive(toggle) {
    menuItem.forEach(item => {
      if (item != toggle) {
        item.classList.remove('active')
      }
    })
    if (toggle.classList.contains('active')) {
      toggle.classList.remove('active')
    } else {
      toggle.classList.add('active')
    }
  }

  function togglePanel(dataID) {
    let previouslyActive = closeOthers(dataID)
    headerPanel.forEach(panel => {
      const innerHeight = panel.querySelector('.inner').offsetHeight
      const columns = panel.querySelector('.columns')

      if (previouslyActive == true) {
        var timeout = 650
      } else {
        var timeout = 0
      }

      if (dataID == panel.dataset.id) {
        if (!panel.classList.contains('active')) {
          setTimeout(() => {
            if (window.innerWidth > 1023) {
              panel.style.height = innerHeight + 'px'
            }
            setTimeout(() => {
              columns.style.opacity = 1
            }, 400);
          }, timeout);
          panel.classList.add('active')
        } else {
          if (window.innerWidth > 1023) {
            panel.style.height = 0
          }
          columns.style.opacity = 0
          panel.classList.remove('active')
        }
      }

        invalidateOnResize(panel)
    })

    setTimeout(() => {
      const outsideClick = (e) => {
        const $target = $(e.target);
        if (!$target.closest(headerPanel).length && !$target.closest(header).length) {
          closeAll()
          document.removeEventListener('click', outsideClick);
        }
      }

      document.addEventListener('click', outsideClick);
    }, 400);
  }

  function invalidateOnResize(panel) {
      window.addEventListener('resize', () => {
          if (window.innerWidth <= 1023) {
              panel.style.height = 'unset'
          } else {
              panel.style.height = 0
          }
      })
  }

  function closeOthers(dataID) {
    let active = false
    headerPanel.forEach(panel => {
      const columns = panel.querySelector('.columns')
      if (panel.classList.contains('active') && dataID != panel.dataset.id) {
        active = true
        if (window.innerWidth > 1023) {
          panel.style.height = 0
        }
        columns.style.opacity = 0
        panel.classList.remove('active')
      }
    })

    return active
  }

  function closeAll() {
    headerPanel.forEach(panel => {
      const columns = panel.querySelector('.columns')
      if (window.innerWidth > 1023) {
        panel.style.height = 0
      }
      columns.style.opacity = 0
      panel.classList.remove('active')
    })
  }
})()
