import {gsap, Power1} from 'gsap'
import { ScrollTrigger } from 'gsap/ScrollTrigger';

gsap.registerPlugin(ScrollTrigger)

export default (() => {
    const filterInspiration = document.querySelector('.filter-inspiration')

    if(filterInspiration) {
        window.addEventListener('load', () => {
            mobileFilterPosition()
            desktopFilterOpen()
        })

        window.addEventListener('resize', () => {
            mobileFilterPosition()
            desktopFilterOpen()
        })

        const singleFilter = filterInspiration.querySelectorAll('.inner')

        singleFilter.forEach((filter) => {
            const elements = filter.querySelectorAll('.single')

            elements.forEach(element => element.addEventListener('click', function () {
                toggleActive(elements, element)
                const newCode = calculateNewCode()
                changeRender(newCode)
            }))
        })

        function desktopFilterOpen() {
            if(window.innerWidth > 1024) {
                const chooseDecors = document.querySelector('.choose-decors.desktop')
                const closeFilter = filterInspiration.querySelector('.close.desktop')
                const timeline2 = gsap.timeline()

                gsap.to(filterInspiration, {
                    y: filterInspiration.offsetHeight,
                    duration: 0,
                })

                timeline2.to(chooseDecors, {
                    y: chooseDecors.offsetHeight + 16,
                    opacity: 0,
                    ease: Power1.easeInOut,
                    duration: 0.3,
                })

                timeline2.to(filterInspiration, {
                    y: 0,
                    opacity: 1,
                    ease: Power1.easeInOut,
                    pointerEvents: 'all',
                    duration: 0.3,
                })

                timeline2.pause()

                chooseDecors && chooseDecors.addEventListener('click', () => {
                    timeline2.play()
                })

                closeFilter && closeFilter.addEventListener('click', () => {
                    timeline2.reverse()
                })
            }
        }
    
        function mobileFilterPosition () {
            if(window.innerWidth < 1024) {
                const height = filterInspiration.offsetHeight
                const offset =  - 75

                filterInspiration.style.opacity = 1
                filterInspiration.style.pointerEvents = 'all'
    
                const chooseDecors = filterInspiration.querySelector('.choose-decors.mobile')
    
                const t1 = gsap.timeline()
                t1.fromTo(filterInspiration, {
                    y: height + offset,
                    ease: Power1.easeInOut,
                    duration: 0.4,
                }, {
                    y: 0,
                    ease: Power1.easeInOut,
                    duration: 0.4,
                })
    
                t1.pause()
    
                let active = false
                chooseDecors.addEventListener('click', () => {
                    if(active == false) {
                        filterInspiration.classList.add('active')
                        t1.play()
                        active = true
                    } else {
                        filterInspiration.classList.remove('active')
                        t1.reverse()
                        active = false
                    }
                })
            } else {
                filterInspiration.style.translateY = 0
            }
        }
    
        function toggleActive (elements, element) {
            if (element.dataset.active) {
                element.removeAttribute('data-active')
            } else {
                elements.forEach(single => {
                    single.removeAttribute('data-active')
                });
    
                element.setAttribute('data-active', '')
            }
        }
    
        function calculateNewCode() {
            const activeElements = filterInspiration.querySelectorAll('.single[data-active]')
            let activeCode = []
            activeElements.forEach((element, index) => {
                if(index != 0) {
                    activeCode.push('_')
                }
                activeCode.push(element.dataset.filterIndex)
            })
    
            return ''.concat(...activeCode)
        }
    
        function changeRender(code) {
            const singleInspiration = document.querySelector('.single-inspiration')
    
            const renders = singleInspiration.querySelectorAll('.renders img')
    
            renders.forEach((render) => {
                const index = render.dataset.renderIndex
                render.style.display = 'none'
    
                if(index == code) {
                    render.style.display = 'inline-block'
                }
            })
        }
    }
})()