@php
    if($is_category) {
        $terms = get_categories($args);
            $args = [
                'hide_empty' => true
            ];
    } else {
        $args = [
            'hide_empty' => true,
            'taxonomy' => $taxonomy,
        ];

        $terms = get_terms($args);
    }

    $current = get_queried_object()->slug;
    $archive_link_active = true;

    if($only_parents):
        $terms = array_filter($terms, function ($term) {
            return !$term->parent ? $term : null;
        });
    endif;

    if($only_queried_children):
        $terms = array_filter($terms, function ($term) {
            $current = get_queried_object()->term_id;
            if($term->parent == $current) {
                return $term;
            }
        });

        $archive_link_active = false;
    endif;

    foreach($terms as $term):
            if($current == $term->slug):
                $archive_link_active = false;
            endif;
    endforeach;

    $currently_queried = App::get_current_queried();
@endphp

<div class="button-wrapper">
    <a class="button outlined @if($archive_link_active) current @endif" href="{!! get_post_type_archive_link($post_type) !!}">
        {!! __('See all', 'thor') !!}
    </a>
    @foreach($terms as $key => $term)
        @php
            $link = App::get_category_link_with_arg($term, $currently_queried, $post_type);
        @endphp
        <a href="{{ $link }}" class="button outlined @if($current == $term->slug)current @endif">
            {!! $term->name !!}
        </a>
    @endforeach
</div>