@php
    $name_a = get_field('name_a') ? : '';
    $name_b = get_field('name_b') ? : '';
    $name_c = get_field('name_c') ? : '';

    $filters = [
        $name_a =>  [
            'f1',
            'f2'
        ],

        $name_b =>  [
            'k1',
            'k2'
        ],

        $name_c =>  [
            't1',
            't2'
        ],
    ];
@endphp


<div class="choose-decors desktop">
    <p>
        {!! __('Choose the decors', 'thor') !!}
    </p>
</div>

<div 
    class="filter-inspiration">

    <div class="choose-decors mobile">
        @svg('images/chevron-compact-up.svg')
        <p>
            {!! __('Choose the decors', 'thor') !!}
        </p>
    </div>

    <div class="close desktop">
        @svg('images/close.svg')
    </div>

    @foreach($filters as $key => $filter)
        <div class="filter" 
            data-filter-name="{!! $key !!}">
            <h3>
                {!! $key !!}
            </h3>

            @php
                $posts = App::get_decors_filter_by_name($filter);
            @endphp

            <div class="inner">
                @php
                    $is_first = true;
                @endphp
                @foreach($posts as $key => $post)
                    @if($post[0])
                        <a
                            class="single"
                            @if($is_first) data-active @endif
                            data-filter-index="{!! $key !!}">
                            <figure>
                                <img
                                    class="lazy"
                                    src="{!! get_the_post_thumbnail_url($post[0]->ID, 'medium') !!}"
                                    data-src="{!! get_the_post_thumbnail_url($post[0]->ID, 'large') !!}"
                                />
                                <div class="filter-active">
                                    @svg('images/tick.svg')
                                </div>
                            </figure>
                            <p>{{ $post[0]->post_title }}</p>
                        </a>
                    @endif
                @php
                    $is_first = false;
                @endphp
                @endforeach
            </div>
        </div>
    @endforeach
</div>