<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function human_filesize($bytes, $decimals = 1){
        $sz = 'BKMGTP';
        $factor = floor((strlen($bytes) - 1) / 3);
        return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . @$sz[$factor];
    }

    public static function get_decors_filter_by_name ($filter) {
        $posts = [];

        foreach($filter as $single) {
            $posts[$single] = get_field($single);
        }

        return $posts;
    }

    public static function has_decor_in_use($tints) {
        $exist = false;

        if($tints) {
            foreach($tints as $tint) {
                if($tint['_decore_in_use_media_ids']) {
                    foreach($tint['_decore_in_use_media_ids'] as $media) {
                        if($media) {
                            $exist = true;
                        }
                    }
                }
            }
        }

        return $exist;
    } 

    public static function decor_is_highlighted($post) {
        $terms = get_the_terms($post, 'highlights');
        if($terms[0]->slug == 1) { return true; }
        return false;
    }

    public static function get_current_queried() {
        $taxonomies = App::get_decor_taxonomies($filter = true);
        $taxonomies[] = 'order';

        foreach($taxonomies as $key=>$taxonomy) {
            if($_GET[$key]) {
                $values[$key] = $_GET[$key];
            }
        }

        return $values;
     }

    public static function get_category_link_with_arg($term, $currently_queried, $post_type = null) {
        $link = get_category_link($term) ? get_category_link($term) : get_term_link($term, $post_type);
        if($currently_queried) {
            foreach($currently_queried as $key => $value) {
                if($value) {
                    $link = add_query_arg($key, $value, $link);
                }
            }
        }

        return $link;
    }

    public static function get_tint_by_code($tint_code, $post_id) {
        if ($tint_code) {
            $meta = get_post_meta($post_id, '_tinte', true);
            if ($meta) {
                foreach ($meta as $single_meta) {
                    if ($single_meta['_codice'] == $tint_code) {
                        return $single_meta;
                    }
                }
            }
        }

        return false;
    }


    public static function remove_single_query_arg($slug, $filter) {
        $query = $_GET[$slug];
        $query_updated = array_diff($query, array($filter));

        if(is_array($query)) {
            $url = remove_query_arg($slug);
            $url = add_query_arg($slug, $query_updated);
        } else {
            $url = remove_query_arg($slug);
        }

        return $url;
    }

    public static function cast_taxonomy_term ($taxonomy, $term) {
        $cast_taxonomy_bool = [
            'metallic_effect',
            'touch_effect'
        ];

        $cast_taxonomy_unit = [
            'maximum_print_height',
            'development'
        ];

        if(in_array($taxonomy, $cast_taxonomy_bool)) {
            if(boolval($term->slug) == false) { return __('No', 'thor'); }
            if(boolval($term->slug) == true || $term == 'Yes') {return __('Yes', 'thor'); }
        }

       if(in_array($taxonomy, $cast_taxonomy_unit)) {
            return $term->name . __(' mm', 'thor');
        }

        return $term->name;
    }


    public static function get_decor_taxonomies($filter = false) {
        if($filter != true) {
            $taxonomies = [
                'decors-category'             => __('Decors Category', 'thor'),
                'development'                 => __('Development', 'thor'),
                'maximum_print_height'        => __('Maximum Print Height', 'thor'),
                'number_of_cylinders'         => __('Number of Cylinders', 'thor'),
                'metallic_effect'             => __('Metallic Effect', 'thor'),
                'touch_effect'                => __('Touch Effect', 'thor'),
            ];
        } else {
            $taxonomies = [
                'features'                    => __('Features', 'thor'),
                'development'                 => __('Development', 'thor'),
                'maximum_print_height'        => __('Max printing H', 'thor'),
                'number_of_cylinders'         => __('Cylinders', 'thor'),
                'metallic_effect'             => __('Metallic Effect', 'thor'),
                'touch_effect'                => __('Touch Effect', 'thor'),
                'intended_use'                => __('Intended use', 'thor'),
            ];
        }

        return $taxonomies;
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'thor');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Results for \'%s\'', 'thor'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'thor');
        }
        return get_the_title();
    }

    public static function get_block_info($block) {
        $id = 'thor-' . $block['slug'] . '-' . $block['id'];

        if (!empty($block['anchor'])) {
            $id = $block['anchor'];
        }

        $className = 'thor-' . $block['slug'];
        if (!empty($block['className'])) {
            $className .= ' container ' . $block['className'];
        }

        if (!empty($block['align'])) {
            $className .= ' align' . $block['align'];
        }

        return array('id' => esc_attr($id), 'classes' => esc_attr($className));
    }

    public function credits()
    {
        return __('Designed and developed by <a href="https://dueper.net" target="_blank">Dueper Design</a>', 'thor');
    }
}
