@php
  $block_info = App::get_block_info($block);

  $gallery = get_field('gallery');
  $size = get_field('size');
@endphp

<div id="{{ $block_info['id'] }}"
     class="{{ $block_info['classes'] }} gallery-block">

    <div class="swiper-container gallery {!! $size !!}">
        <div class="container arrow-container">
            <div class="swiper-button-prev">
              @svg('images/arrow-left.svg')
            </div>
            <div class="swiper-button-next">
              @svg('images/arrow-right.svg')
            </div>
        </div>
        <div class="items-center swiper-wrapper">
            @foreach($gallery as $key => $image)
                <div class="swiper-slide">
                    <figure>
                        <img src="{!! $image['url'] !!}"/>
                        <h6>
                            {!! ((int)$key + 1) . '/' . count($gallery) . ' ' . $image['caption'] !!}
                        </h6>
                    </figure>
                </div>
            @endforeach
        </div>
    </div>
</div>

